as.Date.numeric             package:zoo             R Documentation

_D_a_t_e _C_o_n_v_e_r_s_i_o_n _F_u_n_c_t_i_o_n_s _f_r_o_m _N_u_m_e_r_i_c, _I_n_t_e_g_e_r _a_n_d _t_s _O_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Functions to convert numeric and related classes to objects of
     class '"Date"' representing calendar dates.

_U_s_a_g_e:

     ## S3 method for class 'numeric':
     as.Date(x, ...)

     ## S3 method for class 'integer':
     as.Date(x, ...)
     ## S3 method for class 'ts':
     as.Date(x, offset = 0, ...)

_A_r_g_u_m_e_n_t_s:

       x: An object of class '"numeric"', '"integer"' or '"ts"'
          respectively.

  offset: A value added to 'time(x)'.

     ...: Further arguments. Currently not used.

_D_e_t_a_i_l_s:

     The 'as.Date.integer' method interprets the argument 'x' as the
     number of days since the origin 1970-01-01 so that the origin
     corresponds to 0.  Negative values are allowed.

     The 'as.Date.numeric' method like the 'as.Date.integer' method
     applied to 'floor(x)'.

     The 'as.Date.ts' inspects 'time(x)' and 'frequency(x)': If the
     frequency is 1 or 4 or 12, 'time(x)' is regarded to be annual,
     quarterly or monthly data respectively. If the frequency is
     something else, no coercion is done.

_V_a_l_u_e:

     The 'as.Date' methods return an object of class '"Date"'. In the
     case of 'as.Date.ts' applied to a yearly, quarterly or monthly
     series the earliest date, i.e., first of year, quarter or month,
     is returned.

_S_e_e _A_l_s_o:

     Date for details of the date class

_E_x_a_m_p_l_e_s:

     as.Date(0) # origin, i.e. 1970-01-01

     # all three result in origin and next 9 days
     as.Date(0:9)
     as.Date(0) + 0:9
     myts <- ts(rnorm(10), start = 0)
     as.Date(unclass(time(myts)))

     # both result in ten firsts of year starting 2001-01-01
     as.Date(ts(rnorm(10)), offset = 2000)
     as.Date(ts(rnorm(10), start = 2001))  

     # both result in ten firsts of month starting with 1990-01-01
     as.Date(ts(rnorm(10), start = c(90,1), freq = 12), offset = 1900)  
     as.Date(ts(rnorm(10), start = c(1990,1), freq = 12))  

