### Name: zoo
### Title: Z's Ordered Observations
### Aliases: zoo print.zoo as.zoo.factor summary.zoo str.zoo is.zoo [.zoo
###   head.zoo tail.zoo Ops.zoo t.zoo cumsum.zoo cumprod.zoo cummin.zoo
###   cummax.zoo na.contiguous na.contiguous.default na.contiguous.zoo
###   index2char index2char.default
### Keywords: ts

### ** Examples

## simple creation and plotting
x.Date <- as.Date("2003-02-01") + c(1, 3, 7, 9, 14) - 1
x <- zoo(rnorm(5), x.Date)
plot(x)
time(x)

## subsetting
x[1:3]

## different classes of indexes/times can be used, e.g. numeric vector
x <- zoo(rnorm(5), c(1, 3, 7, 9, 14))
plot(x)
## or POSIXct
y.POSIXct <- ISOdatetime(2003, 02, c(1, 3, 7, 9, 14), 0, 0, 0)
y <- zoo(rnorm(5), y.POSIXct)
plot(y)

## create a constant series
z <- zoo(1, seq(4)[-2])

## create a 0 dimensional zoo series
z0 <- zoo(, 1:4)

## create a 2 dimensional zoo series
z2 <- zoo(matrix(1:12, 4, 3), as.Date("2003-01-01") + 0:3)

## create a factor zoo object
fz <- zoo(gl(2,5), as.Date("2004-01-01") + 0:9)

## create a zoo series with 0 columns
z20 <- zoo(matrix(nrow = 4, ncol = 0), 1:4)



