### Name: model.frame.zoo
### Title: Model Frame for zoo Series
### Aliases: model.frame.AsIs model.frame.zoo model.frame.ts
### Keywords: regression

### ** Examples

yz <- zoo(1:12)^2
xz <- zoo(1:9)^2
fz <- zoo(gl(2,5))

# example of dispatching on response, using diff and
# lag, using a factor and returning residuals and fitted 
# zoo objects
yz.lm <- lm(I(lag(yz) ~ diff(xz) + fz))
residuals(yz.lm)
fitted(yz.lm)

# examples of using list in data argument
lm(I(lag(y) ~ diff(x) + f), list(y = yz, x = xz, f = fz))
lm(I(y ~ x+f), list(y=lag(yz), x=diff(xz), f=fz))

# examples of using a zoo object in the data argument
lm(I(lag(y) ~ diff(x)), merge(y=yz, x=xz))
lm(I(lag(yz) ~ diff(xz)), merge(yz, xz))
lm(I(y ~ x), merge(y = lag(yz), x = diff(xz)))

# using a variety of other modelling functions
# note that residuals and fitted may or may not
# work with these and if they do work may not
# return zoo objects.

# resistant regression
if(require(MASS))
lqs(I(lag(yz) ~ diff(xz)+fz))

# neural network
if(require(nnet))
nnet(I(lag(yz) ~ diff(xz)+fz), size = 1)

# quantile regression
if(require(quantreg))
rq(I(lag(yz) ~ fz), tau = 0.25)

# random forest
set.seed(1)
if(require(randomForest))
randomForest(I(lag(yz) ~ diff(xz) + fz))

# support vector machine
if(require(e1071))
svm(I(lag(yz) ~ diff(xz) + fz))




