### Name: as.Date.numeric
### Title: Date Conversion Functions from Numeric, Integer and ts Objects
### Aliases: as.Date.numeric as.Date.integer as.Date.ts
### Keywords: utilities chron

### ** Examples


as.Date(0) # origin, i.e. 1970-01-01

# all three result in origin and next 9 days
as.Date(0:9)
as.Date(0) + 0:9
myts <- ts(rnorm(10), start = 0)
as.Date(unclass(time(myts)))

# both result in ten firsts of year starting 2001-01-01
as.Date(ts(rnorm(10)), offset = 2000)
as.Date(ts(rnorm(10), start = 2001))  

# both result in ten firsts of month starting with 1990-01-01
as.Date(ts(rnorm(10), start = c(90,1), freq = 12), offset = 1900)  
as.Date(ts(rnorm(10), start = c(1990,1), freq = 12))  




