## pretty prompt
options(prompt = "R> ")

## load packages and data subset
library(strucchange)
data(PhillipsCurve)
uk <- window(PhillipsCurve, start = 1948)

## plot data
plot(uk[, "dp"])

## estimate breakpoints
bp.inf <- breakpoints(dp ~ dp1, data = uk, h = 8)
## look at RSS and BIC
plot(bp.inf)
summary(bp.inf)

## coefficients of single break model
coef(bp.inf, breaks = 1)

## Table 2: two break model
## coefficient estimates
coef(bp.inf, breaks = 2)
## corresponding standard errors
sqrt(sapply(vcov(bp.inf, breaks = 2), diag))
## breakpoints and confidence intervals
confint(bp.inf, breaks = 2)

