## pretty promp
options(prompt = "R> ")

## load packages and data subset
library(strucchange)
data(PhillipsCurve)
uk <- window(PhillipsCurve, start = 1948)

## plot data
plot(uk[, "dp"])

## estimate breakpoints
bp.inf7 <- breakpoints(dp ~ dp1, data = uk, h = 7)
## look at RSS and BIC
plot(bp.inf7)
summary(bp.inf7)

## Table 2: two break model with h = 7
## coefficient estimates
coef(bp.inf7, breaks = 2)
## corresponding standard errors
sqrt(sapply(vcov(bp.inf7, breaks = 2), diag))
## breakpoints and confidence intervals
confint(bp.inf7, breaks = 2)
