## pretty prompt
options(prompt = "R> ")

## load packages and data
library(strucchange)
data(RealInt)

## plot data
plot(RealInt)

## estimate breakpoints
bp.ri <- breakpoints(RealInt ~ 1, h = 15)
## look at RSS and BIC
plot(bp.ri)
summary(bp.ri)

## fit segmented model with three breaks
fac.ri <- breakfactor(bp.ri, breaks = 3, label = "seg")
fm.ri <- lm(RealInt ~ 0 + fac.ri)
summary(fm.ri)

## Table 1:
## coefficient estimates
coef(bp.ri, breaks = 3)
## corresponding standard errors
sapply(vcov(bp.ri, breaks = 3, vcov = kernHAC), sqrt)
## breakpoints and confidence intervals
confint(bp.ri, breaks = 3, vcov = kernHAC)

## Visualization
plot(RealInt)
lines(ts(fitted(fm.ri), start = 1961, freq = 4), col = 4)
lines(confint(bp.ri, breaks = 3, vcov = kernHAC))
