** This is the job for the AM paper, "The Political Economy of Financial Reform: Are Abiad and Mody Right?", submitted/resubmitted to the JAE 
** (results by using the Chinn-Ito dataset not included).
**
**last updated: 25/09/08    Yongfu Huang 

* ****INITIALIZE*****
version 9.2
capture clear
drop _all
set more 1
//#delimit 
program drop _all
set memory 500m
scalar drop _all
capture log close
macro drop _all
set matsize 800
pause on


* *****OPEN DATASET (Abiad-Mody original dataset)*****

//use flidata, clear
//outsheet using fli.csv, replace comma
//insheet using fli.csv, clear

insheet using X:\Research\CommentHuang\Replication\flidata.csv, clear
rename isocode id
gen indx=float(fli/18) if fli~=.
sort id 
save finlib, replace

* *****CONVERT COUNTRY NAMES TO NUMERICAL IDs*****

use finlib,clear
keep id year fli
sort id
collapse fli, by (id)
sort id
gen cn=_n
keep id cn
sort id
merge id using finlib
drop _merge*

sort id year
by id: gen yn=_n
compress
label var cn "numerical id"

* *****CREATE COUNTRY AND YEAR DUMMIES*****
//encode id, gen (cn)
tab id, g(cc)
tab year, g(yy)

* *****DECLARE DATASET AS PANEL DATA*****
iis cn
tis year
tsset cn yn

* ****GENERATE LHS VARIABLES*****
//gen indx=float(fli/18) if fli~=.
gen dindx=D.indx*10000
replace dindx=int(dindx)/10000
label var dindx "Change in FL"
gen indxl=L.indx
gen indxlsq=indxl^2 if indxl~=.
gen dindxl=L.dindx
gen dindxlsq=dindxl^2 if dindxl~=.

//foreach var of varlist cred intr entr regl priv intl {
//	gen `var'x=float(`var'/6) if `var'~=.
//	gen d`var'x=D.`var'x*10000
//	replace d`var'x=int(d`var'x)/10000
//	gen `var'xl=L.`var'x
//	gen `var'xlsq=`var'xl^2 if `var'xl~=.
//}

* *****GENERATE 5-VALUE POLICY VARIABLE FOR BIVARIATE TABLES*****
gen policy=0 if dfli~=.
replace policy=1 if ((dfli==1|dfli==2) & dfli~=.)
replace policy=2 if (dfli>2 & dfli~=.)
replace policy=-1 if ((dfli==-1|dfli==-2) & dfli~=.)
replace policy=-2 if (dfli<-2 & dfli~=.)
label var policy "5-value index of reform or reversal (-2,-1,0,1,2)"
label define policylbl -2 "large reversal" -1 "reversal" 0 "status quo" 1 "reform" 2 "large reform"
label values policy policylbl
gen policyl=L.policy
label values policyl policylbl

* *****GENERATE REVERSAL DUMMY, USED TO CHECK FOR ASYMMETRY*****
gen dum_rvrs=(policy<0) if policy~=.
label var dum_rvrs "dummy indicating reversal"

* *****GENERATE RHS DUMMIES AND INTERACTION VARIABLES*****
gen state=0 if fli~=.
replace state=1 if (fli>=3 & fli<=8 & fli~=.)
replace state=2 if (fli>=9 & fli<=14 & fli~=.)
replace state=3 if (fli>=15 & fli<=18 & fli~=.)
gen statel=0 if flil~=.
replace statel=L.state if flil~=.
label define statelbl 0 "fully repressed" 1 "partially repressed" 2 "largely liberalized" 3 "liberalized"
label values statel statelbl
gen statelsq=statel^2

gen dum_bop=(bop==1 | L.bop==1 | L.L.bop==1)
label var dum_bop "Currency Crisis"
gen bops=0 if bop~=.
replace bops=1 if (bop==1 & bop_ews==1)
gen dum_bops=(bops==1 | L.bops==1 | L.L.bops==1) 
label var dum_bops "Severe Currency Crisis"
gen dum_bank=(bank==1 | L.bank==1 | L.L.bank==1)
label var dum_bank "Banking Crisis"
gen dum_bopbank=dum_bop+2*dum_bank
label define lblbopbank 0 "no crisis" 1 "bop crisis" 2 "bank crisis" 3 "twin crisis"
label values dum_bopbank lblbopbank
gen twin=(dum_bop==1 & dum_bank==1)
label var twin "Twin Crisis"
gen recession=(gdpg<=0) if gdpg~=.
label var recession "Recession"
gen depression=(gdpg<-5) if gdpg~=.
label var depression "Severe Recession"
gen dum_hinfl = (infl>50) if infl~=.
label var dum_hinfl "High Inflation"
gen dum_hyperinfl = (infl>100) if infl~=.
label var dum_hyperinfl "Hyperinflation"
label define crisislbl 0 "no crisis" 1 "crisis"
for varlist dum_bop dum_bank recession: label values X crisislbl

gen dum_1yofc=(yofc==1)
label var dum_1yofc "First Year in Office"

xtile openptile = open, nq(100)
gen openness=0 if openptile~=.
replace openness=1 if (openptile>25 & openptile<=50 & openptile~=.)
replace openness=2 if (openptile>50 & openptile<=75 & openptile~=.)
replace openness=3 if (openptile>75 & openptile~=.)

gen presid=0 if syst~=.
replace presid=1 if (syst==0 | syst==1)

xtile usintptile = usint, nq(100)
gen usintp=0 if usintptile~=.
replace usintp=1 if (usintptile>25 & usintptile<=50 & usintptile~=.)
replace usintp=2 if (usintptile>50 & usintptile<=75 & usintptile~=.)
replace usintp=3 if (usintptile>75 & usintptile~=.)
gen dum_highusint=0 if usintptile~=.
replace dum_highusint=1 if (usintptile>75 & usintptile~=.)
label var dum_highusint "High World Interest Rates"
 

* *****GENERATE LEGAL DUMMIES*****
//gen leg_uk=0
//replace leg_uk=1 if (nid==2 | nid==3 | nid==5 | nid==10 | nid==12 | nid==13 | nid==15 | nid==19 | nid==22 | nid==23 | nid==24 | nid==27 | nid==28 | nid==29 | nid==31 | nid==33 | nid==35)
//gen leg_fra=0
//replace leg_fra=1 if (nid==1 | nid==4 | nid==6 | nid==7 | nid==8 | nid==9 | nid==14 | nid==16 | nid==20 | nid==21 | nid==25 | nid==26 | nid==32 | nid==34)
//gen leg_ger=0
//replace leg_ger=1 if (nid==11 | nid==17 | nid==18 | nid==30)
* *****GENERATE REGIONAL DUMMIES*****
//gen reglatam=0
//replace reglatam=1 if (nid==1 | nid==4 | nid==6 | nid==7 | nid==20 | nid==25 | nid==34)
//gen regeasia=0
//replace regeasia=1 if (nid==14 | nid==18 | nid==19 | nid==26 | nid==27 | nid==30 | nid==31)
//gen regsasia=0
//replace regsasia=1 if (nid==3 | nid==13 | nid==22 | nid==24 | nid==29)
//gen regafrme=0
//replace regafrme=1 if (nid==8 | nid==12 | nid==15 | nid==21 | nid==28 | nid==35)
//gen regoecd=0
//replace regoecd=1 if (nid==2 | nid==5 | nid==9 | nid==10 | nid==11 | nid==16 | nid==17 | nid==23 | nid==32 | nid==33)


* ***** CRTEAT LEGAL DUMMIES & REGIONAL DUMMIES (from the GDN) *****

sort id year
save fin, replace

insheet using X:\Research\CommentHuang\Replication\gdn-fixedfactors.csv, clear
rename regeap regeasia0
rename regsa regsasia0
rename reglac reglatam0
gen regafrme0=regssa+regmena
rename inchighoecd regoecd0
keep isocode legbritish legfrench leggerman reglatam0 regeasia0 regsasia0 regafrme0 regoecd0

replace regoecd0=1 if isocode=="TUR"

rename isocode id
sort id
merge id using fin
drop if year==.
drop _merge*

gen region=0
replace region=1 if reglatam0==1
replace region=2 if regeasia0==1
replace region=3 if regsasia0==1
replace region=4 if regafrme0==1
replace region=5 if regoecd0==1
//label define regionlabel 1 "Latin America" 2 "East Asia" 3 "South Asia" 4 "Africa/ Middle East" 5 "OECD"
//label values region regionlabel
sort region year

//keep id year reg* leg*
//save fintry, replace
//outsheet using finn_ci.csv, replace comma

* *****CREATE "REFORM LEADER" SERIES (MAX(FLIL) PER REGION), AND CATCH UP VARIABLE
by region year: egen max_indxl=max(indxl)
gen catchup=max_indxl-indxl
label var catchup "Difference from Regional Leader"
//foreach var of varlist cred intr entr regl priv intl {
//	by region year: egen max_`var'xl=max(`var'xl)
//	gen catchup_`var'=max_`var'xl-`var'xl
//}

replace exrlc=2 if (exrlc==0 | exrlc==.)
label define exrlclbl -1 "Left" 2 "Center/Other" 1 "Right" 0 "NOT"
label values exrlc exrlclbl
gen exrlc1yofc=exrlc*dum_1yofc
label values exrlc1yofc exrlclbl
gen exrlcbop=exrlc*dum_bop
label values exrlcbop exrlclbl
gen exrlcbank=exrlc*dum_bank
label values exrlcbank exrlclbl
gen left=(exrlc==-1) if exrlc~=.
label var left "Leftist Government"
gen right=(exrlc==1) if exrlc~=.
label var right "Rightist Government"

sort id year
save fingdn, replace

* *****GENERATE INTERACTION TERMS*****

use fingdn, clear
gen left1yofc=(exrlc==-1)*(dum_1yofc==1)
gen leftbop=(exrlc==-1)*(dum_bop==1)
gen leftbank=(exrlc==-1)*(dum_bank==1)
gen right1yofc=(exrlc==1)*(dum_1yofc==1)
gen rightbop=(exrlc==1)*(dum_bop==1)
gen rightbank=(exrlc==1)*(dum_bank==1)
gen cntr1yofc=(exrlc==2)*(dum_1yofc==1)
gen cntrbop=(exrlc==2)*(dum_bop==1)
gen cntrbank=(exrlc==2)*(dum_bank==1)
gen leftn1yofc=(exrlc==-1)*(dum_1yofc==0)
gen leftnbop=(exrlc==-1)*(dum_bop==0)
gen leftnbank=(exrlc==-1)*(dum_bank==0)
gen rightn1yofc=(exrlc==1)*(dum_1yofc==0)
gen rightnbop=(exrlc==1)*(dum_bop==0)
gen rightnbank=(exrlc==1)*(dum_bank==0)
gen cntrn1yofc=(exrlc==2)*(dum_1yofc==0)
gen cntrnbop=(exrlc==2)*(dum_bop==0)
gen cntrnbank=(exrlc==2)*(dum_bank==0)

gen bop1yofc=dum_bop*dum_1yofc
gen bank1yofc=dum_bank*dum_1yofc
gen rec1yofc=recession*dum_1yofc
gen hinf1yofc=dum_hinfl*dum_1yofc

gen bopimf=dum_bop*dum_1yofc
gen bankimf=dum_bank*dum_1yofc
gen recimf=recession*dum_1yofc
gen hinfimf=dum_hinfl*dum_1yofc

gen bopdpc=dum_bop*dpc
gen bankdpc=dum_bank*dpc
gen recdpc=recession*dpc
gen hinfdpc=dum_hinfl*dpc

gen rhs0=(1-indxl)
gen rhs1=indxl*(1-indxl)
label var rhs1 "FL(t-1)*(1-FL(t-1))"
gen rhs1d=dindxl*(1-indxl)
label var rhs1d "D.FL(t-1)*(1-FL(t-1))"
gen rhs1dp=0
replace rhs1dp=dindxl*(1-indxl) if dindxl>0
label var rhs1dp "D.FL(t-1)*(1-FL(t-1)) if D.FL(t-1)>0"
gen rhs1dn=0
replace rhs1dn=dindxl*(1-indxl) if dindxl<0
label var rhs1dn "D.FL(t-1)*(1-FL(t-1)) if D.FL(t-1)<0"

//gen rhs1_cred=credxl*(1-credxl)
//gen rhs1_intr=intrxl*(1-intrxl)
//gen rhs1_entr=entrxl*(1-entrxl)
//gen rhs1_regl=reglxl*(1-reglxl)
//gen rhs1_priv=privxl*(1-privxl)
//gen rhs1_intl=intlxl*(1-intlxl)

gen rhs2=dum_bop*(1-indxl)
gen rhs3=dum_bank*(1-indxl)
gen rhs4=dum_hinfl*(1-indxl)
gen rhs5=recession*(1-indxl)
gen rhs6=dum_1yofc*(1-indxl)
gen rhs7=imf*(1-indxl)
gen rhs8=cntr1yofc*(1-indxl)
gen rhs9=left1yofc*(1-indxl)
gen rhs10=right1yofc*(1-indxl)
gen rhs11=cntrbop*(1-indxl)
gen rhs12=leftbop*(1-indxl)
gen rhs13=rightbop*(1-indxl)
gen rhs14=cntrbank*(1-indxl)
gen rhs15=leftbank*(1-indxl)
gen rhs16=rightbank*(1-indxl)
gen rhs17=cntr1yofc*indxl
gen rhs18=left1yofc*indxl
gen rhs19=right1yofc*indxl
gen rhs20=cntrbop*indxl
gen rhs21=leftbop*indxl
gen rhs22=rightbop*indxl
gen rhs23=cntrbank*indxl
gen rhs24=leftbank*indxl
gen rhs25=rightbank*indxl

gen rhs26=catchup*(1-indxl)
gen rhs27=left*(1-indxl)
gen rhs28=right*(1-indxl)
gen rhs29=usint*(1-indxl)
gen rhs30=open*(1-indxl)

gen indxlcatchup=indxl*catchup
gen indxlbop=dum_bop*indxl
gen indxlbank=dum_bank*indxl
gen indxlrec=recession*indxl
gen indxlhinfl=dum_hinfl*indxl
gen indxl1yofc=dum_1yofc*indxl
gen indxlleft=left*indxl
gen indxlright=right*indxl
gen indxlusint=indxl*usint
gen indxlimf=imf*indxl
gen indxlopen=indxl*open
gen indxl_l1y=left1yofc*indxl
gen indxl_r1y=right1yofc*indxl
gen indxl_c1y=cntr1yofc*indxl
gen indxl_lbop=leftbop*indxl
gen indxl_rbop=rightbop*indxl
gen indxl_cbop=cntrbop*indxl
gen indxl_lbank=leftbank*indxl
gen indxl_rbank=rightbank*indxl
gen indxl_cbank=cntrbank*indxl
gen rvrsusint=dum_rvrs*usint

** adding demo (democracy) **
gen indxldemo=indxl*demo

drop indxl
replace demo=float(demo+10)/20 if demo~=.
tsset cn yn
foreach var of varlist indx gdppcppp open {
        gen `var'l=l.`var'
        gen `var'd=d.`var' 
}     

foreach var of varlist regeasia0 regsasia0 reglatam0 regoecd0 regafrme0 {
      gen yn`var'=yn*`var'
}

gen gdppcindxl=(gdppcppp/1000)*indxl
gen openindxl=openptile*indxl
gen gdppcopenindxl=(gdppcppp/1000)*openptile*indxl

sort id year
save freform1, replace


* *** CROSS COUNTRY AVERAGES (1/N) - Pesaran (2006, 2007) *** *

use freform1, clear

collapse (mean) dindx indxl gdppcpppl open, by (year)
renpfix g mg
renpfix o mo
renpfix i mi
renpfix d md

gen id=1
tsset id year
sort year
save mean, replace

use freform1, clear
sort year id
merge year using mean
drop _merge*
sort id year
save t, replace

** create interaction terms -  region dummies*cross section averages **

use t, clear
drop max*

foreach var of varlist m* {
	gen reg1`var'=regeasia0*`var'
	gen reg2`var'=regsasia0*`var'
      gen reg3`var'=reglatam0*`var'
	gen reg4`var'=regafrme0*`var'
      gen reg5`var'=regoecd0*`var'   

}

//drop m*
sort id year
save mfreform1,replace


* **** SKIP THIS SLOT ***** *

//replace dindx=dindx-mdindx
//replace indxl=indxl-mindxl
//replace indxlsq=indxlsq-mindxlsq
//replace gdppcindxl=gdppcindxl-mgdppcindxl
//replace catchup=catchup-mcatchup
//replace indxlcatchup=indxlcatchup-mindxlcatchup 
//replace dum_bop=dum_bop-mdum_bop 
//replace indxlbop=indxlbop-mindxlbop 
//replace dum_bank=dum_bank-mdum_bank
//replace indxlbank= indxlbank-mindxlbank
//replace recession=recession-mrecession
//replace indxlrec =indxlrec-mindxlrec 
//replace dum_hinfl=dum_hinfl-mdum_hinfl
//replace indxlhinfl=indxlhinfl-mindxlhinfl 
//replace dum_1yofc=dum_1yofc-mdum_1yofc 
//replace indxl1yofc=indxl1yofc-mindxl1yofc 
//replace imf=imf-mimf  
//replace indxlimf=indxlimf-mindxlimf 
//replace usint=usint-musint 
//replace left=left-mleft 
//replace indxlleft=indxlleft-mindxlleft 
//replace right=right-mright 
//replace indxlright=indxlright-mindxlright 
//replace open=open-mopen 
//replace indxlopen=indxlopen-mindxlopen
//replace demo=demo-mdemo 
//replace indxldemo=indxldemo-mindxldemo
//sort id year
//save tfreform1, replace



* *****DESCRIPTIVE TABLES*****
//log using "descriptive_tables.log",replace
*use freform1, clear
*corr cred intr entr regl priv intl
*tab policy region, nofreq column
*tab policy dum_1yofc, chi2 nofreq column
*tab policy dum_highusint, chi2 nofreq column
*tab policy imf, chi2 nofreq column
*tab policy dum_bop, chi2 nofreq column
*tab policy dum_bank, chi2 nofreq column
*tab policy recession, chi2 nofreq column
*tab policy dum_hinfl, chi2 nofreq column
*tab policy statel, chi2 nofreq column
*tab policy exrlc, chi2 nofreq column
*tab policy presid, chi2 nofreq column
*tab policy openness, chi2 nofreq column
//log close



* *****REGRESSIONS**************** *

************************************
****** ologit - ORIGINAL RESULT  ***
************************************

// experiments have been done to address serial correlation by "yy*" , results are saved as "Table7_AM_yy.xls", "Table8_AM_yy.xls" and "Table9_AM_yy.xls" 
// experiments have been done to address serial correlation by  "yreg*", results are saved as "Table7_AM_yreg.xls", "Table8_AM_yreg.xls" and "Table9_AM_yreg.xls"

use freform1, clear

*****BASELINE REGRESSIONS (EQUATION 4, TABLE 7), WITHOUT AND WITH COUNTRY FIXED EFFECTS*****
ologit dindx rhs1 catchup, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle("Without Coutry Dummies") bracket nocons replace
ologit dindx rhs1 catchup dum_bop dum_bank recession dum_hinfl, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle(" ") bracket nocons append
ologit dindx rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle(" ") bracket nocons append

ologit dindx rhs1 catchup cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle("With Country Dummies") bracket nocons append
ologit dindx rhs1 catchup dum_bop dum_bank recession dum_hinfl cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle(" ") bracket nocons append
ologit dindx rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_AM_Repl.xls, ctitle(" ") bracket nocons append

* *****GENERATE SAMPLE MEANS OF RHS VARIABLES TO COMPUTE MARGINAL EFFECTS ON PROBABILITY*****
sum rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc* if e(sample)==1

* *****ALTERNATIVE SPECIFICATIONS (EQUATIONS 5 and 6, TABLE 8)*****

ologit dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_AM_Repl.xls, ctitle("Without Country Fixed Effects") bracket nocons replace
ologit dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_AM_Repl.xls, ctitle(" ") bracket nocons append
ologit dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_AM_Repl.xls, ctitle("With Country Fixed Effects") bracket nocons append
ologit dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_AM_Repl.xls, ctitle(" ") bracket nocons append

* *****ALTERNATIVE SPECIFICATION (EQUATION 8, TABLE 9)*****
ologit dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_AM_Repl.xls, ctitle("Without Country Fixed Effects") bracket nocons replace

*****run joint tests on coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen

ologit dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen cc*, cl(cn)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_AM_Repl.xls, ctitle("With Country Fixed Effects") bracket nocons append
*****run joint tests of coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen

* *****GENERATE GOODNESS OF FIT (TABLE 10)*****
predict sit if e(sample), xb
gen predpolicy=0 if sit~=.
label values predpolicy policylbl
replace predpolicy=-1 if sit < 1.80365

replace predpolicy=1 if sit >= 4.0799
tab policy predpolicy


//log using freform.log, replace



*****************************************************************************
*** WG & CCEP estimations - Tables 1-3 in revised AM paper to JAE  ***
*****************************************************************************

//------------------------------------------
// Abiad and Mody measure
//------------------------------------------

use freform1,clear

** A. Fixed Effects model [with nonrobust standard errors reported here] **

//nonrobust standard errors reported (", fe")
//(stardard) robust standard errors reported (", fe robust")
//panel-robust standard errors reported (", fe cluster (cn)")

//replace " indxl indxlsq " with " rhs1 " to produce "Table7_FE_1A.xls" 
// experiments have been done to address serial correlation by "yy*" , results are saved as "Table7_FE_yy.xls", "Table8_FE_yy.xls" and "Table9_FE_yy.xls" 
// experiments have been done to address serial correlation by  "yreg*", results are saved as "Table7_FE_yreg.xls", "Table8_FE_yreg.xls" and "Table9_FE_yreg.xls"


*****BASELINE REGRESSIONS (EQUATION 4, TABLE 7), WITHOUT AND WITH COUNTRY FIXED EFFECTS*****

xtreg dindx indxl indxlsq catchup, fe 
// below is to count the number of fitted values which lie outside of the admissible range ///
predict varo1 if e(sample), xb
egen varo1mean=mean(varo1)
egen varo1sd=sd(varo1)
gen outo1=cond(varo1>varo1mean-2*varo1sd & varo1<varo1mean+2*varo1sd, 1,0)
outsheet using X:\Research\CommentHuang\Replication\Output\fitted.xls, replace comma
drop varo1 varo1mean varo1sd outo1 
/////////////////////
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b") bracket addstat(csd,g1) nocons replace

xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b ") bracket addstat(csd,g1) nocons append

* *****GENERATE SAMPLE MEANS OF RHS VARIABLES TO COMPUTE MARGINAL EFFECTS ON PROBABILITY*****
sum rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc* if e(sample)==1

* *****ALTERNATIVE SPECIFICATIONS (EQUATIONS 5 and 6, TABLE 8)*****

xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_FE_Repl.xls, se bdec(3) ctitle("Table 2") bracket addstat(csd,g1) nocons replace
xtreg dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_FE_Repl.xls, se bdec(3) ctitle("Table 2 ") bracket addstat(csd,g1) nocons append

* *****ALTERNATIVE SPECIFICATION (EQUATION 8, TABLE 9)*****

xtreg dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen demo indxldemo, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_FE_Repl.xls, se bdec(3) ctitle("Table 3") bracket addstat(csd,g1) nocons replace

*****run joint tests of coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen
test demo indxldemo


** B. Fixed Effect Models [including weighted cross country averages(1/N) with panel-robust standard errors (", fe cluster (cn)")] **

use mfreform1, clear

//drop mindxl mindx mgdppcpppl mgdppcppp mopen mopend cm*l cm*d
**mdindx mindx mgdppcppp mopen are for estimation ***

*****BASELINE REGRESSIONS (EQUATION 4, TABLE 7), WITHOUT AND WITH COUNTRY FIXED EFFECTS*****

xtreg dindx indxl indxlsq catchup reg*mdindx reg*mindxl yy*, fe cluster (cn) 
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl reg*mdindx reg*mindxl yy*, fe cluster (cn) 
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo reg*mdindx reg*mindxl reg*mopen yy*, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_FE_Repl.xls, se bdec(3) ctitle("Table 1b") bracket addstat(csd,g1) nocons append


* *****GENERATE SAMPLE MEANS OF RHS VARIABLES TO COMPUTE MARGINAL EFFECTS ON PROBABILITY*****
sum rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc* if e(sample)==1

* *****ALTERNATIVE SPECIFICATIONS (EQUATIONS 5 and 6, TABLE 8)*****

xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo reg*mdindx reg*mindxl reg*mopen yy*, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_FE_Repl.xls, se bdec(3) ctitle("Table 2") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo reg*mdindx reg*mindxl reg*mopen reg*mgdppcpppl yy*, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_FE_Repl.xls, se bdec(3) ctitle("Table 2 ") bracket addstat(csd,g1) nocons append


* *****ALTERNATIVE SPECIFICATION (EQUATION 8, TABLE 9)*****

xtreg dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen demo indxldemo reg*mdindx reg*mindxl reg*mopen yy*, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_FE_Repl.xls, se bdec(3) ctitle("Table 3") bracket addstat(csd,g1) nocons append

*****run joint tests of coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen
test demo indxldemo


//-----------------------------------
// Table 4 in revised AM paper to JAE
//-----------------------------------

//---------------------------
// Abiad and Mody measure
//---------------------------


use freform1,clear

** A. Fixed Effects model [with robust standard errors reported here] **

//nonrobust standard errors reported (", fe")
//(stardard) robust standard errors reported (", fe robust")
//panel-robust standard errors reported (", fe cluster (cn)")

*****BASELINE REGRESSIONS (EQUATION 4, TABLE 7), WITHOUT AND WITH COUNTRY FIXED EFFECTS*****

xtreg dindx indxl indxlsq catchup, fe cluster (cn) 
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a") bracket addstat(csd,g1) nocons replace
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a ") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a ") bracket addstat(csd,g1) nocons append


* *****GENERATE SAMPLE MEANS OF RHS VARIABLES TO COMPUTE MARGINAL EFFECTS ON PROBABILITY*****
sum rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc* if e(sample)==1

* *****ALTERNATIVE SPECIFICATIONS (EQUATIONS 5 and 6, TABLE 8)*****

xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_T4_Repl.xls, se bdec(3) ctitle("Table 4b") bracket addstat(csd,g1) nocons replace
xtreg dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_T4_Repl.xls, se bdec(3) ctitle("Table 4b ") bracket addstat(csd,g1) nocons append


* *****ALTERNATIVE SPECIFICATION (EQUATION 8, TABLE 9)*****

xtreg dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen demo indxldemo, fe cluster (cn)
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_T4_Repl.xls, se bdec(3) ctitle("Table 4c") bracket addstat(csd,g1) nocons replace

*****run joint tests of coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen
test demo indxldemo


** B. Fixed Effect Models [including weighted cross country averages(1/N) with nonpanel-robust standard errors (", fe cluster (cn)")] **

use mfreform1, clear

//drop mindxl mindxd mgdppcpppl mgdppcpppd mopenl mopend cm*l cm*d
**mdindx mindx mgdppcppp mopen are for estimation ***

*****BASELINE REGRESSIONS (EQUATION 4, TABLE 7), WITHOUT AND WITH COUNTRY FIXED EFFECTS*****

xtreg dindx indxl indxlsq catchup reg*mdindx reg*mindxl yy*, fe 
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl reg*mdindx reg*mindxl yy*, fe 
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a ") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo reg*mdindx reg*mindxl reg*mopen yy*, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table7_T4_Repl.xls, se bdec(3) ctitle("Table 4a ") bracket addstat(csd,g1) nocons append


* *****GENERATE SAMPLE MEANS OF RHS VARIABLES TO COMPUTE MARGINAL EFFECTS ON PROBABILITY*****
sum rhs1 catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open cc* if e(sample)==1

* *****ALTERNATIVE SPECIFICATIONS (EQUATIONS 5 and 6, TABLE 8)*****

xtreg dindx indxl indxlsq catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo reg*mdindx reg*mindxl reg*mopen yy*, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_T4_Repl.xls, se bdec(3) ctitle("Table 4b") bracket addstat(csd,g1) nocons append
xtreg dindx indxl indxlsq gdppcindxl catchup dum_bop dum_bank recession dum_hinfl dum_1yofc imf usint left right open demo  reg*mdindx reg*mindxl reg*mopen reg*mgdppcpppl yy*, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table8_T4_Repl.xls, se bdec(3) ctitle("Table 4b ") bracket addstat(csd,g1) nocons append

* *****ALTERNATIVE SPECIFICATION (EQUATION 8, TABLE 9)*****

xtreg dindx indxl indxlsq catchup indxlcatchup dum_bop indxlbop dum_bank indxlbank recession indxlrec dum_hinfl indxlhinfl dum_1yofc indxl1yofc imf indxlimf usint left indxlleft right indxlright open indxlopen demo indxldemo reg*mdindx reg*mindxl reg*mopen yy*, fe
xtcsd, pesaran show
scalar g1=r(pesaran)
outreg2 using X:\Research\CommentHuang\Replication\Output\Table9_T4_Repl.xls, se bdec(3) ctitle("Table 4c") bracket addstat(csd,g1) nocons append

*****run joint tests of coefficient pairs in Table 9*****
test indxl indxlsq
test catchup indxlcatchup
test dum_bop indxlbop
test dum_bank indxlbank
test recession indxlrec
test dum_hinfl indxlhinfl
test dum_1yofc indxl1yofc
test imf indxlimf
test left indxlleft
test right indxlright
test open indxlopen
test demo indxldemo


//log close








