clear
set mem 500m
insheet using data_truncated_bz.txt

tab dec_major

tab first_major 
tab first_major2

tab second_major 
tab sec_major2

//////////////////////////////////////////////////

// This section generates variables that are then used in subsequent sections, and the summary stats for Table 2


//////////////////////////////////////////////////

replace first_major2 = "area" if first_major2 == "Area Studies"
replace first_major2 = "nat" if first_major2 == "Natural Sciences"
replace first_major2 = "soc1" if first_major2 == "Social Sciences I"
replace first_major2 = "soc2" if first_major2 == "Social Sciences II"
replace first_major2 = "lit" if first_major2 == "Literature and Fine Arts"
replace first_major2 = "eth" if first_major2 == "Ethics and Values"
replace first_major2 = "math" if first_major2 == "Mathematical and Computer Sciences"


replace second_major = "area" if second_major == "Area Studies"
replace second_major = "nat" if second_major == "Natural Sciences"
replace second_major = "soc1" if second_major == "Social Sciences I"
replace second_major = "soc2" if second_major == "Social Sciences II"
replace second_major = "lit" if second_major == "Literature and Fine Arts"
replace second_major = "eth" if second_major == "Ethics and Values"
replace second_major = "math" if second_major == "Mathematical and Computer Sciences"
replace second_major = "eng" if second_major == "Engineering"
replace second_major = "mus" if second_major == "Music Studies"
replace second_major = "educ" if second_major == "Education"
replace second_major = "comm" if second_major == "Communication Studies"
replace second_major = "journ" if second_major == "Journalism"

replace sec_major2 = "area" if sec_major2 == "Area Studies"
replace sec_major2 = "nat" if sec_major2 == "Natural Sciences"
replace sec_major2 = "soc1" if sec_major2 == "Social Sciences I"
replace sec_major2 = "soc2" if sec_major2 == "Social Sciences II"
replace sec_major2 = "lit" if sec_major2 == "Literature and Fine Arts"
replace sec_major2 = "eth" if sec_major2 == "Ethics and Values"
replace sec_major2 = "math" if sec_major2 == "Mathematical and Computer Sciences"
replace sec_major2 = "eng" if sec_major2 == "Engineering"
replace sec_major2 = "mus" if sec_major2 == "Music Studies"
replace sec_major2 = "educ" if sec_major2 == "Education"
replace sec_major2 = "comm" if sec_major2 == "Communication Studies"
replace sec_major2 = "journ" if sec_major2 == "Journalism"


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

		egen init`y'_`x' = mean(`y'`x')  
 
		egen fin`y'_`x' = mean(`x'_`y'2) 
}
}



local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

		sum `y'`x'
}
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
	foreach x of local majornames {
		
		gen `x'_own = 0
		replace `x'_own = 1 if ownfirstmajor == "`x'" | second_major == "`x'"

}



local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "status"
	foreach x of local majornames {


generate rstatus`x' = 9 if status_`x' == 1
replace rstatus`x' = 8 if status_`x' == 2
replace rstatus`x' = 7 if status_`x' == 3
replace rstatus`x' = 6 if status_`x' == 4
replace rstatus`x' = 5 if status_`x' == 5
replace rstatus`x' = 4 if status_`x' == 6
replace rstatus`x' = 3 if status_`x' == 7
replace rstatus`x' = 2 if status_`x' == 8
replace rstatus`x' = 1 if status_`x' == 9		

}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
	foreach x of local majornames {

		generate status`x' = rstatus`x' /10
		sum status`x'
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

		egen init`y'_`x'_major = mean(`y'`x')  if ownfirstmajor == "`x'" | second_major == "`x'"
		egen init`y'_`x'_Nmajor = mean(`y'`x')  if ownfirstmajor != "`x'" &  second_major != "`x'"

		egen fin`y'_`x'_major = mean(`x'_`y'2) if first_major2 == "`x'" | sec_major2 == "`x'"
		egen fin`y'_`x'_Nmajor = mean(`x'_`y'2) if first_major2 != "`x'" & sec_major2 != "`x'"


}
}




local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

	sum init`y'_`x'_major init`y'_`x'_Nmajor fin`y'_`x'_major fin`y'_`x'_Nmajor
	
}
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

		gen iinit`y'_`x'_major = `y'`x' if ownfirstmajor == "`x'" | second_major == "`x'"
		gen iinit`y'_`x'_Nmajor = `y'`x'  if ownfirstmajor != "`x'" &  second_major != "`x'"

		gen ifin`y'_`x'_major = `x'_`y'2 if first_major2 == "`x'" | sec_major2 == "`x'"
		gen ifin`y'_`x'_Nmajor = `x'_`y'2 if first_major2 != "`x'" & sec_major2 != "`x'"


}
}





local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
	foreach x of local majornames {
	gen majorinit`x' = 0
	gen majorfin`x' = 0 
  	replace majorinit`x' = 1 if ownfirstmajor == "`x'" | second_major == "`x'"
	replace majorfin`x' = 1 if  first_major2 == "`x'" | sec_major2 == "`x'"
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
	foreach x of local majornames {
	tab majorinit`x'
}



local majornames "nat math soc1 soc2 eth area lit eng"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

	sort majorinit`x' 
	sum `y'`x'
	ttest `y'`x', by(majorinit`x')

}
}

local majornames "nat math soc1 soc2 eth area lit eng"
local attributes "gpa enjoy"
	foreach x of local majornames {
		foreach y of local attributes {

	sort majorinit`x' 
	sum `y'`x'
	ttest `y'`x', by(dec_major)

}
}



local majornames "nat math soc1 soc2 eth area lit eng"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
	foreach x of local majornames {
		foreach y of local attributes {

	sort majorfin`x' 
	ttest `x'_`y'2, by(majorfin`x')

}
}


local majornames "nat math soc1 soc2 eth area lit eng"
	foreach x of local majornames {

		sort majorinit`x' 
		sum status`x'
		ttest status`x', by(majorinit`x')
}




save data_JAE_submit, replace


/////////////////////////////////////////////////////


//// THIS SECTION GENERATES NUMBERS FOR TABLE 3 and 4


////////////////////////////////////////////////////



/* raw changes in beliefs */

use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_change_`y' = .
		gen s_pref_change_`y' = .		
		gen sp_pref_change_`y' = .
		gen l_pref_change_`y' = .
		gen ll_pref_change_`y' = .
		gen lll_pref_change_`y' = .
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		gen change_`y'_`x' =	`x'_`y'2 - `y'`x'

}
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_change_`y' = change_`y'_`x' if  `x'_rating1 == 1
		replace s_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_change_`y' = change_`y'_`x' if  pref_`x' >5 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"

}
}


local types "m s sp l ll lll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		gen `x'_nochange_`y' = 0


}
}

local types "m s sp l ll lll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs"
	foreach x of local types {	
		foreach y of local attributes {

		replace `x'_nochange_`y' = 1 if  abs(`x'_pref_change_`y')<=5
			
}
}


local types "m s sp l ll lll"
local attributes "salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		replace `x'_nochange_`y' = 1 if  abs(`x'_pref_change_`y')<=5000
			
}
}


local types "m s sp l ll lll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		egen `x'_abs_`y' = mean(abs(`x'_pref_change_`y'))
		egen `x'_pos_change_`y' = mean(`x'_pref_change_`y') if `x'_pref_change_`y' > 0
		egen `x'_neg_change_`y' = mean(`x'_pref_change_`y') if `x'_pref_change_`y' < 0
			
}
}


///// the first 3 rows in each panel in table 3

local types "m s sp l ll lll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		sum `x'_pref_change_`y' `x'_pos_change_`y' `x'_neg_change_`y' `x'_abs_`y' `x'_nochange_`y' 
 
			
}
}


///// the fourth row (proportion of responses that are not multiples of 5)

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_round_`y' = 0
		gen s_round_`y' = 0		
		gen sp_round_`y' = 0
		gen l_round_`y' = 0
		gen ll_round_`y' = 0
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_round_`y' = 1 if  `x'_rating1 == 1 & mod(`x'_`y'2, 5) != 0 
		replace s_round_`y' = 1 if  `x'_rating2 == 1 & moreonemajor2 == "No" & mod(`x'_`y'2, 5) != 0 
		replace sp_round_`y' = 1 if  `x'_rating2 == 1 & moreonemajor2 == "Yes"	& mod(`x'_`y'2, 5) != 0 	
		replace l_round_`y' = 1 if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category" & mod(`x'_`y'2, 5) != 0 
		replace ll_round_`y' = 1 if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study" & mod(`x'_`y'2, 5) != 0 
}
}


local types "m s sp l ll ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {
			
		sum `x'_round_`y'

}
} 


/// proportion of responses NOT Multiple of 5 excluding extermities (LAST row in each panel in Table 3)


local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen em_round_`y' = 0
		gen es_round_`y' = 0		
		gen esp_round_`y' = 0
		gen el_round_`y' = 0
		gen ell_round_`y' = 0
}




local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace em_round_`y' = 1 if  `x'_rating1 == 1 & mod(`x'_`y'2, 5) != 0  &  `x'_`y'2  > 5 &  `x'_`y'2 < 95 
		replace es_round_`y' = 1 if  `x'_rating2 == 1 & moreonemajor2 == "No" & mod(`x'_`y'2, 5) != 0  &   `x'_`y'2  > 5 &  `x'_`y'2 < 95 
		replace esp_round_`y' = 1 if  `x'_rating2 == 1 & moreonemajor2 == "Yes"	& mod(`x'_`y'2, 5) != 0  &  `x'_`y'2  > 5 &  `x'_`y'2 < 95 	
		replace el_round_`y' = 1 if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category" & mod(`x'_`y'2, 5) != 0  &  `x'_`y'2  > 5 &  `x'_`y'2 < 95    
		replace ell_round_`y' = 1 if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study" & mod(`x'_`y'2, 5) != 0  &  `x'_`y'2  > 5 &  `x'_`y'2 < 95  
}
}

local types "m s sp l ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		foreach x of local types {	
			
			sum e`x'_round_`y'

}
} 


////////////////////////////////////////////////////////////////////////

// THis section generates numbers for Table 5

////////////////////////////////////////////////////////////////////////


//the magnitude of changes in beliefs 

use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_change_`y' = .
		gen s_pref_change_`y' = .		
		gen sp_pref_change_`y' = .
		gen l_pref_change_`y' = .
		gen ll_pref_change_`y' = .
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		gen change_`y'_`x' =	`x'_`y'2 - `y'`x'

}
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_change_`y' = change_`y'_`x' if  `x'_rating1 == 1
		replace s_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
}
}


local types "m s sp l ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		sum `x'_pref_change_`y'
			
}
}

gen id_new= _n

local types "m s sp l ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		rename `x'_pref_change_`y' pref_change_`y'_`x'
}
}

reshape long pref_change_grad_ pref_change_gpa_ pref_change_enjoy_ pref_change_coursework_ pref_change_approval_ pref_change_findjob_ pref_change_enjoywork_ pref_change_reconcile_ pref_change_jobhrs_ pref_change_salary30_ pref_change_salary40_, i(id_new) j(majorrank) string


save reshapedJAE.dta, replace

use reshapedJAE.dta, clear

gen secmajordummy = 0
replace secmajordummy = 1 if majorrank == "sp"

gen secprefdummy = 0
replace secprefdummy = 1 if majorrank == "s"

gen dropmajordummy = 0
replace dropmajordummy = 1 if majorrank == "l"

gen leastprefdummy = 0
replace leastprefdummy = 1 if majorrank == "ll"






local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
 	foreach x of local attributes {
		xtreg pref_change_`x'_ secmajordummy secprefdummy dropmajordummy leastprefdummy, i(id_new) re cluster(id_new)
}		


tab dec_major

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
 	foreach x of local attributes {
		xtreg pref_change_`x'_ secmajordummy secprefdummy dropmajordummy leastprefdummy if dec_major == 1, i(id_new) re 
		
}		


local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30"
 	foreach x of local attributes {
		xtreg pref_change_`x'_ secmajordummy secprefdummy dropmajordummy leastprefdummy if dec_major == 0, i(id_new) re 
		
}





////////////////////////////////////////////////////////////////

/// This section generates Table 6 numbers

/////////////////////////////////////////////////////////////////


use data_JAE_submit, clear



local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_change_`y' = .
		gen s_pref_change_`y' = .		
		gen sp_pref_change_`y' = .
		gen l_pref_change_`y' = .
		gen ll_pref_change_`y' = .
}


local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		gen change_`y'_`x' =	`x'_`y'2 - `y'`x'

}
}





local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_change_`y' = change_`y'_`x' if  `x'_rating1 == 1
		replace s_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
}
}


local types "m s sp l ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		sum `x'_pref_change_`y'
			
}
}

gen id_new= _n

local types "m s sp l ll"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		rename `x'_pref_change_`y' pref_change_`y'_`x'
}
}


local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen most_pref_change_`y' = 0
		gen sec_pref_change_`y' = 0		
		gen least_pref_change_`y' = 0
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

			replace most_pref_change_`y' = change_`y'_`x' if  `x'_rating1 == 1
			replace sec_pref_change_`y' = change_`y'_`x' if  `x'_rating2 == 1
			replace least_pref_change_`y' = change_`y'_`x' if  `x'_ratingleast == 1	
}
}



local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen most_pref_belief_`y' = "0"
		gen sec_pref_belief_`y' = "0"		
		gen least_pref_belief_`y' = "0"
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace most_pref_belief_`y' = b_`y'_`x' if `x'_rating1 == 1
		replace sec_pref_belief_`y' = b_`y'_`x' if `x'_rating2 == 1
		replace least_pref_belief_`y' = b_`y'_`x' if `x'_ratingleast == 1
}
}


local majornames "most sec least"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

			replace `x'_pref_belief_`y' = "-" if `x'_pref_belief_`y' == "About the same"
			replace `x'_pref_belief_`y' = "+1" if `x'_pref_belief_`y' == "Higher"
			replace `x'_pref_belief_`y' = "-1" if `x'_pref_belief_`y' == "Lower"
}
}


local types "most sec least"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		gen `x'_pref_computed_`y' = "."


}
}

local types "most sec least"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

			replace `x'_pref_computed_`y' = "unchanged" if abs(`x'_pref_change_`y') <= 5
			replace `x'_pref_computed_`y' = "increased" if `x'_pref_change_`y' > 5
			replace `x'_pref_computed_`y' = "decreased" if `x'_pref_change_`y' < -5
			
}
}

local types "most sec least"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local types {	
		foreach y of local attributes {

		replace `x'_pref_computed_`y' = "-" if `x'_pref_computed_`y' == "unchanged"
		replace `x'_pref_computed_`y' = "+1" if `x'_pref_computed_`y' == "increased"
		replace `x'_pref_computed_`y' = "-1" if `x'_pref_computed_`y' == "decreased"
		
}
}


local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs"
	foreach x of local attributes {
		tab most_pref_computed_`x' most_pref_belief_`x'
		tab sec_pref_computed_`x' sec_pref_belief_`x'
		tab least_pref_computed_`x' least_pref_belief_`x'
}




//////////////////////////////////////////


///This section generates figures


//////////////////////////////////////////



use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_`y' = .
		gen s_pref_`y' = .		
		gen sp_pref_`y' = .
		gen l_pref_`y' = .
		gen ll_pref_`y' = .
		gen lll_pref_`y' = .

		gen m_pref_`y'_2 = .
		gen s_pref_`y'_2 = .
		gen sp_pref_`y'_2 = .		
		gen l_pref_`y'_2 = .
		gen ll_pref_`y'_2 = .
		gen lll_pref_`y'_2 = .
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_`y' = `y'`x' if  `x'_rating1 == 1
		replace s_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y' = `y'`x' if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"

		replace m_pref_`y'_2 = `x'_`y'2  if  `x'_rating1 == 1
		replace s_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "Yes"
		replace l_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y'_2 = `x'_`y'2 if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"


}
}

cumul m_pref_enjoy, gen(cum_enjoy) equal
cumul m_pref_enjoy_2, gen(cum_enjoyf) equal
stack cum_enjoy m_pref_enjoy cum_enjoyf m_pref_enjoy_2, into(c temp) wide clear

histogram m_pref_enjoy, width(5) fraction color(erose) addplot(line cum_enjoy cum_enjoyf temp, sort lwidth(medthick) lpattern(dash) lcolor(erose) || histogram m_pref_enjoy_2, fraction width(5) lcolor(green) color(none) lwidth(medthick))  title("Belief Distribution For Most Preferred Major") ytitle("Cumulative Density") xtitle("Subjective Probability of Enjoying Coursework (0-100)") legend(off) graphregion(fcolor(gs16))

graph save "H:\Move\Follow-Up\Stata\Enjoy_MostPref", replace
graph export C:\Enjoy_MP.emf, replace

/////

use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_`y' = .
		gen s_pref_`y' = .		
		gen sp_pref_`y' = .
		gen l_pref_`y' = .
		gen ll_pref_`y' = .
		gen lll_pref_`y' = .

		gen m_pref_`y'_2 = .
		gen s_pref_`y'_2 = .
		gen sp_pref_`y'_2 = .		
		gen l_pref_`y'_2 = .
		gen ll_pref_`y'_2 = .
		gen lll_pref_`y'_2 = .
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_`y' = `y'`x' if  `x'_rating1 == 1
		replace s_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y' = `y'`x' if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"

		replace m_pref_`y'_2 = `x'_`y'2  if  `x'_rating1 == 1
		replace s_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "Yes"
		replace l_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y'_2 = `x'_`y'2 if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"


}
}

cumul ll_pref_enjoy, gen(cum_enjoy) equal
cumul ll_pref_enjoy_2, gen(cum_enjoyf) equal
stack cum_enjoy ll_pref_enjoy cum_enjoyf ll_pref_enjoy_2, into(c temp) wide clear

histogram ll_pref_enjoy, width(5) fraction color(erose) addplot(line cum_enjoy cum_enjoyf temp, sort lwidth(medthick) lpattern(dash) lcolor(erose) || histogram ll_pref_enjoy_2, fraction width(5) lcolor(green) color(none) lwidth(medthick))  title("Belief Distribution For Least Preferred Major") ytitle("Cumulative Density") xtitle("Subjective Probability of Enjoying Coursework (0-100)") legend(col(2) order(2 3 1 4) lab(2 "First Survey") lab(3 "Final Survey") lab(1 "Histogram for First Survey") lab(4 "Histogram for Final Survey")) graphregion(fcolor(gs16))

graph save "H:\Move\Follow-Up\Stata\Enjoy_LeastPref", replace
graph export C:\Enjoy_LP.emf, replace

graph combine "H:\Move\Follow-Up\Stata\Enjoy_MostPref" "H:\Move\Follow-Up\Stata\Enjoy_LeastPref", row(2)
graph export H:\pic_Enjoy_evolve.tif, replace

////////////////////////////


use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_`y' = .
		gen s_pref_`y' = .		
		gen sp_pref_`y' = .
		gen l_pref_`y' = .
		gen ll_pref_`y' = .
		gen lll_pref_`y' = .

		gen m_pref_`y'_2 = .
		gen s_pref_`y'_2 = .
		gen sp_pref_`y'_2 = .		
		gen l_pref_`y'_2 = .
		gen ll_pref_`y'_2 = .
		gen lll_pref_`y'_2 = .
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_`y' = `y'`x' if  `x'_rating1 == 1
		replace s_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y' = `y'`x' if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"

		replace m_pref_`y'_2 = `x'_`y'2  if  `x'_rating1 == 1
		replace s_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "Yes"
		replace l_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y'_2 = `x'_`y'2 if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"


}
}


drop if m_pref_salary30 < 10000 | m_pref_salary30_2 < 10000 | ll_pref_salary30_2 < 10000| ll_pref_salary30 < 10000 | ll_pref_salary30 > 200000 | ll_pref_salary30_2 > 200000 | m_pref_salary30 > 200000 | m_pref_salary30_2 > 200000

replace m_pref_salary30 = m_pref_salary30/1000
replace m_pref_salary30_2 = m_pref_salary30_2/1000
replace ll_pref_salary30 = ll_pref_salary30/1000
replace ll_pref_salary30_2 = ll_pref_salary30_2/1000

cumul m_pref_salary30, gen(cum_salary) equal
cumul m_pref_salary30_2, gen(cum_salary_2) equal
stack cum_salary m_pref_salary30 cum_salary_2 m_pref_salary30_2, into(c temp) wide clear

histogram m_pref_salary30, width(5) fraction color(erose) addplot(line cum_salary cum_salary_2 temp, sort lwidth(medthick) lpattern(dash) lcolor(erose) || histogram m_pref_salary30_2, fraction width(5) lcolor(green) color(none) lwidth(medthick))  title("Belief Distribution For Most Preferred Major") ytitle("Cumulative Density") xtitle("Expected Earnings at Age 30 in $1000s") legend(off) graphregion(fcolor(gs16))

graph save "H:\Move\Follow-Up\Stata\salary_MostPref", replace
graph export C:\salary_MP.emf, replace



use data_JAE_submit, clear

local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach y of local attributes {
		gen m_pref_`y' = .
		gen s_pref_`y' = .		
		gen sp_pref_`y' = .
		gen l_pref_`y' = .
		gen ll_pref_`y' = .
		gen lll_pref_`y' = .

		gen m_pref_`y'_2 = .
		gen s_pref_`y'_2 = .
		gen sp_pref_`y'_2 = .		
		gen l_pref_`y'_2 = .
		gen ll_pref_`y'_2 = .
		gen lll_pref_`y'_2 = .
}

local majornames "nat math soc1 soc2 eth area lit mus comm educ eng journ"
local attributes "grad gpa enjoy coursework approval findjob enjoywork reconcile jobhrs salary30 salary40"
	foreach x of local majornames {
		foreach y of local attributes {

		replace m_pref_`y' = `y'`x' if  `x'_rating1 == 1
		replace s_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y' = `y'`x' if  `x'_rating2 == 1 & moreonemajor2 == "Yes"		
		replace l_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y' = `y'`x' if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y' = `y'`x' if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"

		replace m_pref_`y'_2 = `x'_`y'2  if  `x'_rating1 == 1
		replace s_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "No"
		replace sp_pref_`y'_2 = `x'_`y'2  if  `x'_rating2 == 1 & moreonemajor2 == "Yes"
		replace l_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The first definition, i.e. you once pursued a major in that category"
		replace ll_pref_`y'_2 = `x'_`y'2  if  `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"
		replace lll_pref_`y'_2 = `x'_`y'2 if  pref_`x' >4 & `x'_ratingleast == 1 & least_field_def == "The second definition, i.e. it is your actual least preferred field of study"


}
}

drop if m_pref_salary30 < 10000 | m_pref_salary30_2 < 10000 | ll_pref_salary30_2 < 10000| ll_pref_salary30 < 10000 | ll_pref_salary30 > 200000 | ll_pref_salary30_2 > 200000 | m_pref_salary30 > 200000 | m_pref_salary30_2 > 200000

replace ll_pref_salary30 = 300000 if ll_pref_salary30 == 500000

replace m_pref_salary30 = m_pref_salary30/1000
replace m_pref_salary30_2 = m_pref_salary30_2/1000
replace ll_pref_salary30 = ll_pref_salary30/1000
replace ll_pref_salary30_2 = ll_pref_salary30_2/1000

cumul ll_pref_salary30, gen(cum_salary) equal
cumul ll_pref_salary30_2, gen(cum_salary_2) equal
stack cum_salary ll_pref_salary30 cum_salary_2 ll_pref_salary30_2, into(c temp) wide clear

histogram ll_pref_salary30, width(5) fraction color(erose) addplot(line cum_salary cum_salary_2 temp, sort lwidth(medthick) lpattern(dash) lcolor(erose) || histogram ll_pref_salary30_2, fraction width(5) lcolor(green) color(none) lwidth(medthick))  title("Belief Distribution For Least Preferred Major") ytitle("Cumulative Density") xtitle("Expected Earnings at Age 30 in $1000s") legend(col(2) order(2 3 1 4) lab(2 "First Survey") lab(3 "Final Survey") lab(1 "Histogram for First Survey") lab(4 "Histogram for Final Survey")) graphregion(fcolor(gs16))

graph save "H:\Move\Follow-Up\Stata\salary_LeastPref", replace
graph export C:\salary_LP.emf, replace


graph combine "H:\Move\Follow-Up\Stata\salary_MostPref" "H:\Move\Follow-Up\Stata\salary_LeastPref", row(2)
graph export H:\pic_salary_evolve.tif, replace



