function [Fh,Lh,uh,V,Ch,Z]=pcestim(X,Y,m,r)

% Principal component factor estimation
% with observed factors Y that are orthogonal to Fh

[T,N]       = size(X);

if m==0
    Ch      = [];
    Z       = X;
else
    Ch      = (X'*Y)/(Y'*Y);
    Z       = X- Y*Ch';
end

[T,N]       = size(Z);
[Evec Eval] = eig(Z*Z'/(T*N));


[Evals,idx] = sort(diag(Eval),1,'descend');
Fh          = [];

for i=1:r
    pos     = idx(i,1);
    Fh      = [Fh Evec(:,pos)];
    V(i,i)  = Eval(pos,pos);
end

Fh          = Fh.*sqrt(T);
Lh          = (Z'*Fh)/(Fh'*Fh);
uh          = Z-Fh*Lh';
    
    

