function irf = irfgen(shock,A,R,L,C,xind,hmax,p,r,m)

k        = r+m;
ims      = shock*R';
prs      = [ims zeros(1,(p-1)*k)];

for h=1:hmax
    imsl = prs*A;
    ims  = [ims;imsl];
    prs  = [imsl prs(:,1:(p-1)*k)];
end

irf      = [];
for h=1:hmax
   if m==0
      sshock = ims(h,1:r)*L(xind,:)' ;   
   else
      sshock = ims(h,1:r)*L(xind,:)' + ims(h,r+1:end)*C(xind,:)' ;
   end
  irf    = [irf; sshock];
end    
  
