function [Q,pvQ] = test_ident(e1,e2,r)

    % Test for identification condition
    
    T1   = size(e1,1);
    T2   = size(e2,1);
    Sig1 = e1'*e1/T1;
    Sig2 = e2'*e2/T2;
    
    k1 = 1;
    k2 = r;
    
    % ---
    % constructing kappas
    e12 = [e1;e2];
    S40                  = diag(e12'*e12/(T1+T2)).^2;
    
    ebar10               = mean(e1)';
    ebar20               = mean(e2)';
    Z10                  = (sum((e1-ones(T1,1)*ebar10').^4)'-6*S40)./(T1-4);
    Z20                  = (sum((e2-ones(T2,1)*ebar20').^4)'-6*S40)./(T2-4);
    W10                  = (T1/(T1-1))*(S40-Z10./T1);
    W20                  = (T2/(T2-1))*(S40-Z20./T2);
    kappa1               = (1/(3*r))*sum(Z10./W10)-1;
    kappa2               = (1/(3*r))*sum(Z20./W20)-1;

    csq                  = 1/(((1+kappa1)/T1+(1+kappa2)/T2));

    [~,LB]               = eig(Sig2/Sig1);
    lb                   = diag(LB);
    Q                    = csq*(-sum(log(lb(k1:k2,1)))+(k2-k1+1)*log(sum(lb(k1:k2,1))/(k2-k1+1)));
    pvQ                  = 1-chi2cdf(Q,((k2-k1+3)*(k2-k1)/2));

    disp([' * Test for identification condition: ', num2str(pvQ)]);

end