function R = crdataset(filename,labels,transf,sdate,edate)

    N = size(labels,2);

    for n=1:N
        label = char(labels(n));
        [DataNan,txt]=xlsread(filename,label);
        Dates0 = DataNan(:,1:3);

        switch label
            case 'MPEvents'
                DataMP  = DataNan(:,4:5); % MPD and Testimony
                DataMP(isnan(DataMP)) = 0; % nan=0
                DataMP = sum(DataMP,2);
                DatesMP = Dates0(DataMP==1,:);
            otherwise
                Data0  = DataNan(:,4:end);
                Names0 = txt(1,4:end);

                iS = find(Dates0(:,1)==sdate(1) & Dates0(:,2)==sdate(2) & Dates0(:,3)==sdate(3));
                iE = find(Dates0(:,1)==edate(1) & Dates0(:,2)==edate(2) & Dates0(:,3)==edate(3));

                DatesFin = Dates0(iS:iE,:); % dates from sdate to edate
                DataFin0 = Data0(iS-1:iE,:);  % data from sdate-1 to edate

                    % fill nan by the value one business day before
                    T=size(DataFin0,1);
                    for t=1:T
                        this = DataFin0(t,:);
                        if isnan(this)
                            DataFin0(t,:) = DataFin0(t-1,:);
                        end
                    end

                if transf(n)==1
                    DataFin1  = DataFin0(2:end,:)-DataFin0(1:end-1,:);  % first difference
                else
                    if transf(n)==2
                        DataFin1  = 100*(DataFin0(2:end,:)./DataFin0(1:end-1,:)-1);  % growth rate
                    else
                        DataFin1  = DataFin0(2:end);  % raw data
                    end
                end

                % data and dates for monetary policy announcement days
                [~,locMP] = ismember(datetime(DatesMP),datetime(DatesFin)); 
                locMP = locMP(locMP>0);
                DatesFinAD = DatesFin(locMP,:);
                DataFinAD = DataFin1(locMP,:);

                % Data for non-announcement days
                % 1) business days excluding the announcement days (Arai 2017)
                IsAD = ismember(datetime(DatesFin),datetime(DatesFinAD)); 
                DatesFinND = DatesFin(~IsAD,:); 
                DataFinND = DataFin1(~IsAD,:);

                % 2) one day prior to announcement days (Rigobon and Sack 2004)
                DatesFinND_RS = DatesFin(locMP-1,:); 
                DataFinND_RS = DataFin1(locMP-1,:);

                if n==2
                    DataFin = DataFin1;

                    DatesAD = DatesFinAD; 
                    DataAD  = DataFinAD; 
                    Names   = Names0;

                    DatesND = DatesFinND;     
                    DataND  = DataFinND; 

                    DatesND_RS = DatesFinND_RS;     
                    DataND_RS  = DataFinND_RS; 
                else
                    diffAD = abs(DatesAD-DatesFinAD);
                    diffND = abs(DatesND_RS-DatesFinND_RS);
                    if diffAD+diffND>0
                        disp(' *** error: policy dates are different from the previous round');
                    else
                        DataFin = [DataFin,DataFin1];
                        DataAD  = [DataAD,DataFinAD];
                        Names   = [Names,Names0];

                        DataND    = [DataND   ,DataFinND   ];
                        DataND_RS = [DataND_RS,DataFinND_RS];
                    end
                end

        end


    end

    R.DataAD    = DataAD;
    R.DatesAD   = DatesAD;
    R.Names  = Names;

    % Non-announcement days = all business days excluding announcement days
    R.DataND    = DataND;
    R.DatesND   = DatesND;

    % Non-announcement days = one day prior to announcement days
    R.DataND_RS = DataND_RS;
    R.DatesND_RS = DatesND_RS;

    R.Data   = DataFin;
    R.Dates  = DatesFin;

end

