/*********************************************************************/
* This file conducts overidentification tests of the IV models using
* bootstrapped standard errors. These tests are based on a nearest-
* neighbor cutoff for the IV variables.
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/
	
* Set drive
	clear all
	cd "...\JAE Data Archive"
	
* Set bootstrap reps and seed
	global bootreps = 500
	global bootseed = 5
		
* Loop to conduct overidentification tests
	qui{
	foreach d of numlist 8 9 10 11 12{
	
		* First-stage IVs - percentage of undeveloped land is excluded instrument
		global overids prespercent_fe_`d'nn zndltqnt_ct_fe_`d'nn

		* Second-stage variables
		global overid_test_vars develop dstbaltcen surprimerd areaacre zndltqnt ///
		sewer floodplne septicsuit slpe3prcnt exhouse prespercent udarea ///
		zndltqnt_ct apprvltqnt landprices1k houseprices1k $overids confunc_p confunc_p2 ///
		y_2-y_14 carrind harfind		

		* Display rings
		noi di `d'
		
		* Read data
		use "Second_Stage_Duration_Data_`d'_NearN", clear
		
		* Probit model
		noi bootstrap, reps($bootreps) cluster(id) seed($bootseed): ///
		probit $overid_test_vars
		
		* Conduct overidentification test
		noi test $overids
		
	}
	}
	

	