/*********************************************************************/
* This file estimates the truncated poisson models using bootstrapped 
* standard errors.
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/
	
* Set drive
	clear all
	cd "...\JAE Data Archive"
	
* Set bootstrap reps and seed
	global bootreps = 500
	global bootseed = 5

/**************************/
* Non-IV Models
/**************************/
	
* Read data
	import delimited using "Second_Stage_Poisson_Data", clear
	
* Second-stage variables
	global noniv_model_vars ltqnt dstbaltcen surprimerd areaacre zndltqnt ///
	sewer floodplne septicsuit slpe3prcnt exhouse prespercent ///
	udarea zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	y_2-y_14 carrind harfind
	
* Poisson model
	bootstrap, reps($bootreps) cluster(id) seed($bootseed): ///
	tpoisson $noniv_model_vars, ll(1)
	
* Elasticity value for price
	margins, eyex(houseprices1k)
	
/**************************/
* IV Models
/**************************/

* Read data
	use "Second_Stage_Poisson_Data_12_NearN", clear

* Second-stage variables
	global iv_model_vars ltqnt dstbaltcen surprimerd areaacre zndltqnt ///
	sewer floodplne septicsuit slpe3prcnt exhouse ///
	prespercent udarea zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	confunc_p confunc_p2 y_2-y_14 carrind harfind
	
* Poisson model
	bootstrap, reps($bootreps) cluster(id) seed($bootseed): ///
	tpoisson $iv_model_vars, ll(1)
	
* Elasticity value for price
	margins, eyex(houseprices1k)
	

	

	
	
	
	
	
	
	
		
	
	
