/*********************************************************************/
* This file estimates the second-stage duration models using
* bootstrapped standard errors. These models are based on a distance 
* cutoff for the IV variables.
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/
	
* Set drive
	clear all
	cd "...\JAE Data Archive"

* Set bootstrap reps and seed
	global bootreps = 500
	global bootseed = 5
	
/**************************/
* Non-IV Model
/**************************/
	
* Read data
	use "Second_Stage_Duration_Data_5_Miles", clear
	
* Set variables
	global noniv_model_vars develop dstbaltcen surprimerd areaacre ///
	zndltqnt sewer floodplne septicsuit slpe3prcnt exhouse prespercent ///
	udarea_ct zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	y_2-y_14 carrind harfind
	
* Estimate model
	bootstrap, reps($bootreps) cluster(id) seed($bootseed): probit $noniv_model_vars
	
* Elasticity value for price
	margins, eyex(houseprices1K)
	
/**************************/
* IV Models
/**************************/

* Set variables
	global iv_model_vars develop dstbaltcen surprimerd areaacre ///
	zndltqnt sewer floodplne septicsuit slpe3prcnt exhouse ///
	prespercent udarea_ct zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	confunc_p confunc_p2 y_2-y_14 carrind harfind

* Loop to run IV models
	qui{
	foreach d of numlist 3 4 5{
	
	* Estimate model
		use "Second_Stage_Duration_Data_`d'_Miles", clear
		noi bootstrap, reps($bootreps) cluster(id) seed($bootseed): probit $iv_model_vars
	
	* Elasticity value for price
		noi margins, eyex(houseprices1K)
		
	}
	}


