clear all
set more off
cd "/Users/bwilliams/allfiles/everything/research/my research projects/testscoreregressions/submissiontoJAE/replication files/nlsy"
use nlsy_v1_full

*** sample restrictions and generated variables

keep if age==30
save nlsy_v1_age30
export delimited using nlsy_v1_age30.csv, replace
 
gen exp2=exp^2
gen collegeHS=.
replace collegeHS=1 if hgc~=. & hgc>12
replace collegeHS=0 if hgc<=12
rename HGC_MOTHER_1979 mhgc
rename HGC_FATHER_1979 fhgc


foreach var of varlist hgc asvab_mk* asvab_pc* asvab_wk* asvab_ar* rosenberg1-rosenberg5 rotter1-rotter4 urban* region* mhgc fhgc {
drop if `var'==. | `var'<0
}

drop if hours<35*weeks 
drop if asvab_mkJi<25
drop if asvab_pcJi<15
drop if asvab_wkJi<35
drop if asvab_arJi<30 
drop if rosenbergJi<10
drop if rotterJi<4
drop if missing(LavgwklyW)
duplicates drop CASEID, force

local controlvars urban* mhgc fhgc region* year*

rename ASVAB_MATHKNOW_IRT_ZSCORE asvab_mk_irt
rename ASVAB_ARREASON_IRT_ZSCORE asvab_ar_irt
rename ASVAB_PARACOMP_IRT_ZSCORE asvab_pc_irt
rename ASVAB_WORDKNOW_IRT_ZSCORE asvab_wk_irt


** export data



outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 hgc `controlvars' using nlsy_matlab_hgc_wm.txt if sex==1 & white==1, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 hgc `controlvars' using nlsy_matlab_hgc_wf.txt if sex==0 & white==1, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 hgc `controlvars' using nlsy_matlab_hgc_nwm.txt if sex==1 & white==0, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 hgc `controlvars' using nlsy_matlab_hgc_nwf.txt if sex==0 & white==0, replace nol non

outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 collegeHS `controlvars' using nlsy_matlab_chs_wm.txt if sex==1 & white==1, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 collegeHS `controlvars' using nlsy_matlab_chs_wf.txt if sex==0 & white==1, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 collegeHS `controlvars' using nlsy_matlab_chs_nwm.txt if sex==1 & white==0, replace nol non
outsheet LavgwklyW asvab_mk1-asvab_mk25 asvab_pc1-asvab_pc15 asvab_wk1-asvab_wk35 asvab_ar1-asvab_ar30 rosenberg1-rosenberg5 rotter1-rotter4 collegeHS `controlvars' using nlsy_matlab_chs_nwf.txt if sex==0 & white==0, replace nol non




