% Monte Carlo simulations.

clear all
cd '/Users/bwilliams/allfiles/everything/research/my research projects/testscoreregressions/submissiontoJAE/replication files/monte carlo'

    Jset=[50 100 500]; 
    Nset=[1000 2000]; 
    MC=2000; 

% model 1 (identical irf's) vary n,J, w/ a=1
m=1;
a=1;

for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=X;
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,1)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,1)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]
        end
end    

% model 1 (identical irf's) vary n,J w/ a=2
m=1;
a=2;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=X;
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,2)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8);  
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,2)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]            
        end
end

% model 1 (identical irf's) vary n,J, w/ a=4
m=1;
a=4;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=X;
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,3)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,3)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]
        end
end


% model 2 (identical irf's) vary n,J, w/ a=1
m=2;
a=1;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^2.*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,1)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,1)=inv(eD'*eD)*eD'*eY;
            end
            save results_all            
            [a m n J]
        end
end    

% model 2 (identical irf's) vary n,J w/ a=2
m=2;
a=2;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^2.*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,2)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,2)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]
        end
end

% model 2 (identical irf's) vary n,J, w/ a=4
m=2;
a=4;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^2.*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,3)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8);  
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,3)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]
        end
end


% model 3 (identical irf's) vary n,J, w/ a=1
m=3;
a=1;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^(1/2).*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,1)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,1)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,1)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]            
        end
end    

% model 3 (identical irf's) vary n,J w/ a=2
m=3;
a=2;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^(1/2).*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,2)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,2)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8);  
                 clear thhat
                %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,2)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]            
        end
end

% model 3 (identical irf's) vary n,J, w/ a=4
m=3;
a=4;
for Ncnt=1:length(Nset),
    n=Nset(Ncnt);
    for Jcnt=1:length(Jset),
        J=Jset(Jcnt);
            rng(1000000*m+100*n+J+a);
            alphs=linspace(-1,1,J);
            delts=linspace(1,5,J);
            delts=delts(randperm(length(delts)));
            for mc=1:MC,
                X=normrnd(0,1,n,1);
                X0=(abs(X)).^(1/2).*sign(X);
                X0=(X0-mean(X0))/sqrt(var(X0));
                D=(0+a*X0+normrnd(0,1,n,1)>0);
                Y=D+X0+normrnd(0,1,n,1);
                u=rand(n,J);
                Mjs=(u<(exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)))));
                pjs=exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs))./(1+exp((ones(n,1)*delts).*(X*ones(1,J)-ones(n,1)*alphs)));
                Mbars=mean(Mjs(:,1:J),2);
                pbars=mean(pjs(:,1:J),2);

                % model simulated, now estimating
                W=[ones(n,1) D pbars];
                bhatOLSinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                W=[ones(n,1) D X];
                bhatIRTinf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
                %%%% feasible OLS
                W=[ones(n,1) D Mbars];
                bhatOLSf(:,mc,Ncnt,Jcnt,m,3)=inv(W'*W)*W'*Y;
               %% irt
                 for i=1:n,
                     thhat(i)=thhat2pl(Mjs(i,:),delts,alphs,-4,4);
                 end
                 thhat=reshape(thhat,n,1);
                 W=[ones(n,1) D thhat];
                 bhatirt(:,mc,Ncnt,Jcnt,m,3)=inv(W(abs(thhat)<3.8,:)'*W(abs(thhat)<3.8,:))*W(abs(thhat)<3.8,:)'*Y(abs(thhat)<3.8); 
                clear thhat
                 %%% semiparametric
                trimp=.05;
                [temp x Jx]=kreg2(Y,Mbars,[],Mbars,trimp,.04);
                eY=Y-temp(Jx)';
                [temp x Jx]=kreg2(D,Mbars,[],Mbars,trimp,.04);
                eD=D-temp(Jx)';
                Mbars_c=(Mbars-0.5*(quantile(Mbars,trimp)+quantile(Mbars,1-trimp))*ones(size(Mbars)))/(.5*(quantile(Mbars,1-trimp)-quantile(Mbars,trimp)));
                eD=eD.*(functionS(Mbars_c)).^(1/2);
                eY=eY.*(functionS(Mbars_c)).^(1/2);
                bhatplr(mc,Ncnt,Jcnt,m,3)=inv(eD'*eD)*eD'*eY;
            end
            save results_all
            [a m n J]
        end
end