function true_ratio = true_identify(b, group_true, b_true_group, tol)
% get the true identification ratio

K = max(group_true);
b = round(b*1e4) / 1e4;
[p, N] = size(b);
if (p < N)
    b = b';
end
N = length(group_true);

true_num = zeros(K, 1);
for ii = 1:K
    btemp = b(group_true==ii, :);
    [c,~,ic1] = unique(btemp,'rows');
    true_num(ii) = sum(ic1==mode(ic1));
    if (norm(c(mode(ic1),:)' - b_true_group(:,ii), 1) > tol)
        warning('inaccurate estimate');
    end
end

true_ratio = sum(true_num) / N;
end
    
