function dist_matrix = slope_distance(b, n)
% b is the initial estimate, n means we use L^n norm in calculating the
% distance between slopes

if (nargin == 1)
    n = 1;
end

[p, N] = size(b);
if p > N
	N = p;
end

dist_matrix = zeros(N, N);
for ii = 1:N
    for jj = 1:N
        dist_matrix(ii,jj) = norm(b(:,ii) - b(:,jj), n);
    end
end

end

