function [segment, withinG, neighborG] = segments_panel(b)
% using K-means to construct groups and find the neighboring groups

% we assume here that we know the true number of groups is known to be 3,
% later on we will write code to choose K consistently. Actually, we can
% choose larger groups, but not smaller ones.
K = 3;

[p, N] = size(b);
if (p < N)
    b = b';
end
[N, ~] = size(b);


[segment, c] = kmeans(b, K);
c_criteria = criteria_para(c');
[~, ind] = sort(c_criteria);
temp = segment;
for ii=1:K    
    segment(temp==ind(ii))=ii;
end

temp = repmat(segment, 1, N);
temp = abs(temp - temp');
withinG = (temp==0);
neighborG = (temp==1);

end

