function [b_oracle, K, obj_fun, aa] = oracle_panel_te_cvx(y, x, group_true, T)

[n, p] = size(x);
N = n/T;
group_true = group_true(:);
K = max(group_true);

% b_oracle = zeros(N, p);
X_te = kron(ones(N, 1), eye(T));

cvx_quiet(true)
%%%%%%%%%
cvx_begin
%%%%%%%%%

variable aa(K, p);
variable t_fe(T, 1);
expression b_oracle;
% expression t_mean_all;

% t_mean_all = repmat(mean(t_fe), N*T, 1);

b_oracle = aa(group_true, :);

b_all = kron(b_oracle, ones(T, 1));


obj_fun_with_te = 1/(N*T) * sum_square(y - sum(x .* b_all, 2) - (X_te - 1/T * ones(N*T, T))*t_fe);

minimize(obj_fun_with_te);


%%%%%%%
cvx_end
%%%%%%%
y_temp = reshape(y, T, N);
y_temp = repmat(mean(y_temp, 2), 1, N);
y_reshape = reshape(y_temp, N*T, 1);
x_temp = reshape(sum(x .* b_all, 2), T, N);
x_temp = repmat(mean(x_temp, 2), 1, N);
x_reshape = reshape(x_temp, N*T, 1);

obj_fun = 1/(N*T) * sumsqr(y - sum(x .* b_all, 2) - (y_reshape - x_reshape));

b_oracle = b_oracle';

end


