function [alpha_bc, vcov, alpha, bias] = oracle_panel_te_bias_vcov(y, x, group_true, T)

[b_oracle, K, ~, alpha] = oracle_panel_te_cvx(y, x, group_true, T);
b_all = kron(b_oracle', ones(T, 1));
[n, p] = size(x);
N = n/T;

y_temp = reshape(y, T, N);
y_temp = repmat(mean(y_temp, 2), 1, N);
y_reshape = reshape(y_temp, N*T, 1);

x_temp = reshape(sum(x .* b_all, 2), T, N);
x_temp = repmat(mean(x_temp, 2), 1, N);
x_reshape = reshape(x_temp, N*T, 1);

u_hat = y - sum(x .* b_all, 2) - (y_reshape - x_reshape);


group_true = group_true(:);
group_true_all = kron(group_true, ones(T, 1));

x_bb = zeros(N*T, p);
for kk = 1:K
    num_kk = sum(group_true == kk);
    x_temp1 = x(group_true_all==kk, :);
    for jj = 1:p
        x_temp2 = x_temp1(:, jj);
        x_temp3 = reshape(x_temp2, T, num_kk);
        x_temp3 = sum(x_temp3, 2)/N;
        x_temp3 = repmat(x_temp3, 1, num_kk);
        x_temp3 = reshape(x_temp3, num_kk*T, 1);
        x_bb(group_true_all==kk, jj) = x_temp2 - x_temp3;
    end
end

Q_NT1 = zeros(K*p, K*p);
B_NT = zeros(K*p, 1);
Omega_NT = zeros(K*p, K*p);
for kk = 1:K
    ind_1 = (kk-1)*p + 1;
    ind_2 = kk*p;
    num_kk = sum(group_true == kk);
    x_temp1 = x_bb(group_true_all == kk, :);
    x_temp2 = x(group_true_all == kk, :);
    u_temp = u_hat(group_true_all == kk);
    Q_kNT = x_temp1' * x_temp2 / (num_kk*T);
    Q_NT1(ind_1:ind_2, ind_1:ind_2) = Q_kNT;
    B_NT(ind_1:ind_2) = b_knt(x_temp1, u_temp, T);
    Omega_NT(ind_1:ind_2, ind_1:ind_2) = omega_knt(x_temp2, u_temp, N, T);
end

Q_NT2 = zeros(K*p, K*p);
for k1 = 1:K
    ind_row_1 = (k1-1)*p + 1;
    ind_row_2 = k1*p;
    for k2 = 1:K
        ind_col_1 = (k2-1)*p + 1;
        ind_col_2 = k2*p;
        Q_kl = q_kl(x_bb(group_true_all==k1, :),...
                    x(group_true_all==k2, :), N, T);
        Q_NT2(ind_row_1:ind_row_2, ind_col_1:ind_col_2) = Q_kl;
    end
end

Q_NT = Q_NT1 - Q_NT2;
bias = Q_NT \ B_NT;
alpha_prime = alpha';
alpha_vector = alpha_prime(:);
alpha_bc_temp = alpha_vector + bias; % double check here
alpha_bc_temp = reshape(alpha_bc_temp, p, K);
alpha_bc = alpha_bc_temp';

vcov = inv(Q_NT) * Omega_NT * inv(Q_NT) / (N*T);

end


