function [b_oracle, K] = oracle_panel_te(y, x, group_true, T)

[n, p] = size(x);
N = n/T;
group_true_exact = kron(group_true, ones(T,1));
K = max(group_true);

b_oracle = zeros(p, N);
for ii = 1:K
    num_ind = sum(group_true == ii);
	if num_ind == 1
        y_temp = y(group_true_exact==ii);
        x_temp = x(group_true_exact==ii, :);
        b_temp = panel_fe(y_temp, x_temp, T); 
        b_oracle(:,group_true==ii) = repmat(b_temp, 1, sum(group_true==ii));
    else
        y_temp = y(group_true_exact==ii);
        x_temp = x(group_true_exact==ii, :);
        y_temp = demean_te(y_temp, T);
        x_temp = demean_te(x_temp, T);
        b_temp = panel_fe(y_temp, x_temp, T); 
        b_oracle(:,group_true==ii) = repmat(b_temp, 1, sum(group_true==ii));
    end
end

end


