function Omega_kNT = omega_knt(x_k, u_k, N, T)

[n, p] = size(x_k);

Omega_kNT = zeros(p, p);

num_k = n/T;
x_k_perp = zeros(n, p);

for jj = 1:p
    x_k_jj = x_k(:, jj);
    x_temp = reshape(x_k_jj, T, num_k);
    x_temp = sum(x_temp, 2)/N;
    x_temp_bar = mean(x_temp);
    x_temp = repmat(x_temp, 1, num_k);
    x_k_jj_corrected = x_k_jj - x_temp(:) + x_temp_bar;
    x_k_perp(:, jj) = x_k_jj_corrected;
end

for ii = 1:num_k
    ind_1 = (ii-1)*T + 1;
    ind_2 = ii*T;
    x_temp = x_k_perp(ind_1:ind_2, :);
    u_temp = u_k(ind_1:ind_2);
    u_temp = repmat(u_temp, 1, p);
    x_temp_2 = x_temp .* u_temp;
    Omega_kNT = Omega_kNT + x_temp_2' * x_temp_2;
end

Omega_kNT = N * Omega_kNT/(num_k^2 * T);

end

