function penalty_G = multi_level_matrix(b, level)

if size(b, 1) < size(b, 2) % make b a N*p matrix
    b = b';
end

[N, p] = size(b);
penalty_temp = zeros(N, N, p);

for ii = 1:p
    segment = zeros(N, 1);
    b_criteria = b(:, ii);

    [~, ind] = sort(b_criteria);
    
    % changing back the labeling
    segment(ind) = (1:N)';
    
    % decide the penalties
    temp = repmat(segment, 1, N);
    temp = abs(temp - temp');
    penalty_temp(:, :, ii) = ismember(abs(temp),[1:2, 1:2:level]) * 1;

end

penalty_G = sum(penalty_temp, 3);