function [beta_est_J, beta_est, beta_bar_T, beta_bar_N]  = jackknife_estimate_twoway(y, X, T, num_avg)
% split panel Jackknife, develop on Chen et al. (2014)


if nargin == 3
    num_avg = 100;
end
p = size(X, 2);
N = length(y) / T;

y_d = demean(y, T);
X_d = demean(X, T);

y_d = demean_te(y_d, T);
X_d = demean_te(X_d, T);

beta_est = X_d \ y_d;

period1_i = [ones(floor(T/2), 1); zeros( ceil(T/2),1)];
period1 = logical(kron(ones(N, 1), period1_i));
period2 = logical(1 - period1);

beta_T = zeros(p, 2);

for tt = 1:2
    if tt == 1
        X_half = X(period1, :);
        y_half = y(period1);
    elseif tt == 2;
        X_half = X(period2, :);
        y_half = y(period2);
    end
    half_t = size(y_half, 1)/N;
    
    X_half = demean(X_half, half_t);    
    y_half = demean(y_half, half_t);
    
    y_half = demean_te(y_half, half_t);
    X_half = demean_te(X_half, half_t);
    
    b = X_half \ y_half;
    beta_T(:,tt) = b;
end
beta_bar_T =  mean(beta_T, 2);

beta_N = zeros(p, num_avg);
N_half = round(N/2);
index_vector = kron((1:N)', ones(T, 1));
for ii = 1:num_avg
    N_choose = randsample(N, N_half);
    N_choose_ind = ismember(index_vector, N_choose);
    y_N = y(N_choose_ind);
    X_N = X(N_choose_ind, :);
   
    y_d = demean(y_N, T);
    X_d = demean(X_N, T);
    
    y_d = demean_te(y_d, T);
    X_d = demean_te(X_d, T);
    
    beta_N(:, ii) = X_d \ y_d;
end
beta_bar_N =  mean(beta_N, 2);

beta_est_J = 3*beta_est - beta_bar_T - beta_bar_N;


end

