function [b, K_new] = eliminate_trivial_group(x, y, T, b_prelim, eta)

[N, p] = size(b_prelim);
if N < p
    b_prelim = b_prelim';
    [N, ~] = size(b_prelim);
end

[~, ~, model] = unique(b_prelim,'rows');
K = max(model);
group_member_num = zeros(K, 1);
for ii = 1:K
	group_member_num(ii) = sum(model==ii);
end

min_group_num = N * eta;
keep_ind = find(group_member_num > min_group_num);
trivial_ind = find(group_member_num <= min_group_num);

keep_length = length(keep_ind);
trivial_length = length(trivial_ind);
if ( trivial_length < 1 || keep_length < 1 )
    K_new = max(model);
    b = oracle_panel(y, x, model, T);
end

if ( trivial_length >= 1 && keep_length >=1 )
    model_new = model;
    choose_rss = zeros(keep_length, 1);
    for jj = 1:min_group_num
        temp_ind = find(group_member_num == jj);
        for kk = 1:length(temp_ind)
            ind_num = find(model == temp_ind(kk));
            for ss = 1:length(ind_num)
                for ii = 1:keep_length
                    model_new(ind_num(ss)) = keep_ind(ii);
                    [~, ~, group] = unique(model_new);
                    [~, ~, sigma2] = oracle_panel_te_cvx(y, x, group, T);                    
%                     b_all = kron(b_temp', ones(T,1));
%                     x_reshape = reshape(sum(x.*b_all,2), T, N);
%                     x_reshape = repmat(mean(x_reshape,2),1,N);
%                     x_reshape = reshape(x_reshape, N*T, 1);
%                     choose_rss(ii) = sum((y - sum(x.*b_all,2) - (y_reshape - x_reshape)).^2)/(N*T);
                    choose_rss(ii) = sigma2;
                end
                [~, choose_ind] = min(choose_rss);
                model_new(ind_num(ss)) = keep_ind(choose_ind);
            end
        end
    end

    [~, ~, model] = unique(model_new);
    K_new = max(model);
    b = oracle_panel_te_cvx(y, x, model, T);
end

end

