function [y_demeaned, te] = demean_te(y, T)
% demean time effects for y and X when the time dimension is T

[NT, p] = size(y);
N = NT/T;
y_temp = reshape(y, T, N*p);
te = zeros(T, p);
for ii = 1:p
    ind_1 = N*(ii-1) + 1;
    ind_2 = N*ii;
    y_temp2 = y_temp(:, ind_1:ind_2);
    y_temp2_mean = mean(y_temp2, 2);
    te(:, ii) = y_temp2_mean';
    y_temp(:, ind_1:ind_2) = y_temp2 - repmat(y_temp2_mean, 1, N);
end

y_demeaned = reshape(y_temp, NT, p);

end
