function y_demeaned = demean(y, T)
% demean for y and X when the time dimension is T

[NT, p] = size(y);
N = NT/T;

y_temp = reshape(y, T, N*p);
y_mean = mean(y_temp);

y_temp = y_temp - repmat(y_mean, T, 1);

y_demeaned = reshape(y_temp, NT, p);

end
