function b = criteria_para(b_unitwise)
%PANEL_CRITERIA use the unit-wise estimate of panel model parameters to 
%construct a criteria through which we can get the grouping properties.

% input:  b_unitwise is p * N
% output: b is N * 1

[~, N] = size(b_unitwise);
b_temp = b_unitwise';

mean_b = mean(b_temp);
mean_b_all = kron(mean_b, ones(N,1));
b_temp2 = b_temp ./ mean_b_all;

b_var = var(b_temp2);

[~, ind] = max(b_var);

b = b_temp(:,ind);

end

