param p;
param N;
param T;

set  P :=1..p;
set NN :=1..N;
set TT :=1..T;

param x{NN, TT, P};
param y{NN, TT};
param bweights{NN, NN};

var b{NN, P};
var vdb{NN, NN, P};

minimize TotalError: 0.5/N/T*(sum{i in NN, t in TT} (y[i,t] - (sum{j in P} x[i,t,j] * b[i,j])) * (y[i,t] - (sum{j in P} x[i,t,j] * b[i,j]))) + (sum{i in NN, l in NN, j in P} bweights[i,l] * vdb[i, l, j]);

subject to con20 {i in NN, l in NN, j in P}: vdb[i, l, j] >= b[i,j] - b[l,j];
subject to con21 {i in NN, l in NN, j in P}: vdb[i, l, j] >= b[l,j] - b[i,j];
