function  [classi_rslt, ssr_aftr, ssr_bfr] = binary_seg(beta)
% beta (N by p) matrix is the preliminary estimator, we will divide it to
% two segments, the classification result is stored in classi_res, and
% ssr(1) is ssr of the first segment ssr(2) is the ssr of the second
% segment

[N, p] = size(beta);
[~, ind] = sort(beta, 1);

beta_demean = beta - repmat(mean(beta, 1), size(beta, 1), 1);
ssr_bfr = norm(beta_demean, 'fro') * norm(beta_demean, 'fro');

classi_rslt = zeros(N, 1);

ssr_matrix = zeros(N-1, p);
for ii = 1:(N-1)
    for jj = 1:p
        beta_1 = beta(ind(1:ii,jj), :);
        % demean
        beta_1 = beta_1 - repmat(mean(beta_1, 1), size(beta_1, 1), 1);
        ssr1 = norm(beta_1, 'fro') * norm(beta_1, 'fro');
        
        beta_2 = beta(ind(ii+1:end,jj), :);
        % demean
        beta_2 = beta_2 - repmat(mean(beta_2, 1), size(beta_2, 1), 1);
        ssr2 = norm(beta_2, 'fro') * norm(beta_2, 'fro');
        
        ssr_matrix(ii, jj) = ssr1 + ssr2;
    end
end
[ssr_aftr, loc] = min(ssr_matrix(:));
[row, col] = ind2sub(size(ssr_matrix), loc);

classi_rslt(ind(1:row,col)) = 1;
classi_rslt(ind(row+1:end,col)) = 2;

end

