function ampl_write_param_panel(fname, N, T, p, x, y)
% This function writes the parameters into an AMPL data file.

fid=fopen(fname,'w');

fprintf(fid,'param N := %d;\n', N);
fprintf(fid,'param T := %d;\n', T);
fprintf(fid,'param p := %d;\n\n', p);

fprintf(fid,'param x :=\n');
for ii = 1:N
    fprintf(fid,'[%d,*,*]:', ii);
    for jj = 1:p
        fprintf(fid,'\t%d',jj);
    end
    fprintf(fid,' :=');
    for kk = 1:T
        fprintf(fid, '\n%d', kk);
        for jj = 1:p
            ind = (ii-1)*T + kk;
            fprintf(fid, '\t%.10f', x(ind, jj));
        end
    end
    if (ii ~= N)
        fprintf(fid, '\n');
    end    
end
fprintf(fid, ';\n\n');

fprintf(fid,'param y :\n');
for t=1:T
    fprintf(fid,'\t%d',t);
end
fprintf(fid,' :=');
for ii=1:N
    fprintf(fid, '\n%d', ii);
    for t=1:T
        ind = (ii-1)*T + t;
        fprintf(fid, '\t%.10f', y(ind));
    end
end
fprintf(fid, ';\n\n');

fclose(fid);
end




