function [obj, b] = ampl_read_sol_panel(filename, p, N)

% This function reads the solutions from the AMPL output file

fid = fopen(filename,'r');

obj_keyword = 'TotalError = ';
b_keyword = 'b [*,*]'; 

m = length(obj_keyword);
temp = fgetl(fid);
while (~isnumeric(temp))
    if (length(temp)>= m)
        if (strcmp(temp(1:m), obj_keyword))
            obj = str2double(temp(m+1:end));
            break;
        end
    end
    temp = fgetl(fid);
end
if (isnumeric(temp))
    error('Cannot read the objective value from AMPL!');
end

temp = fgetl(fid);
while (~isnumeric(temp))
    if (strcmp(temp, b_keyword))
        break;
    end
    temp = fgetl(fid);
end
if (isnumeric(temp))
    error('Cannot read the vector b from AMPL!');
end
temp = fgetl(fid);

b = zeros(p, N);
for ii = 1:N
    temp = fgetl(fid);
    mynum = str2num(temp);
    b(:,ii) = mynum(2:p+1)';
end

fclose(fid);
end

