param p;
param N;
param T;

set  P :=1..p;
set NN :=1..N;
set TT :=1..T;

param x{NN, TT, P};
param y{NN, TT};
param bweights{NN, NN};

var b{NN, P};
var vdb{NN, NN, P};

minimize TotalError: 0.5/N/T*(sum{i in NN, t in TT} (y[i,t] - 1/N * (sum{k in NN} y[k,t]) - (sum{j in P} x[i,t,j] * b[i,j]) + 1/N * (sum{k in NN, j in P} x[k,t,j] * b[k,j])) * (y[i,t] - 1/N * (sum{k in NN} y[k,t]) - (sum{j in P} x[i,t,j] * b[i,j]) + 1/N * (sum{k in NN, j in P} x[k,t,j] * b[k,j]))) + (sum{i in NN, l in NN, j in P} bweights[i,l] * vdb[i, l, j]);

subject to con20 {i in NN, l in NN, j in P}: vdb[i, l, j] >= b[i,j] - b[l,j];
subject to con21 {i in NN, l in NN, j in P}: vdb[i, l, j] >= b[l,j] - b[i,j];
