function [segment, withinG, neighborG] = segments_panel(b_criteria, k)
% delta is the number of groups we want to generate using b
if k < 2
    error('k should be at least 2');
end

N = size(b_criteria,1);

segment = zeros(N,1);

[bsort, ind] = sort(b_criteria);
b_diff = diff(bsort);
[~, ind_diff] = sort(b_diff, 'descend');
delta = b_diff(ind_diff(k-1));

segpoint = find(diff(bsort)>= delta);
if (isempty(segpoint))
    tempseg = ones(N,1);
else
    L = length(segpoint);
    tempseg = zeros(N,1);
    tempseg(1:segpoint(1)) = 1;
    for s = 2:L
        tempseg((segpoint(s-1)+1):segpoint(s))=s;
    end
    tempseg((segpoint(L)+1):N) = L+1;
end
    
% changing back the labeling
segment(ind) = tempseg;
    
% decide the penalties
temp = repmat(segment, 1, N);
temp = abs(temp - temp');
withinG = (temp==0);
neighborG = (temp==1);

end

