function [segment, withinG, neighborG] = segments(b, delta)

% b: a p-by-1 coefficient vector
% delta: parameters to control segmentation

% segment:  p-by-1 matrices storing the segment labels  
% withinG:  p-by-p matrices indicating the within-segment penalty terms
% neighborG:  p-by-p matrices indicating the between-segment penalty terms


p = size(b,1);

segment = zeros(p,1);

[bsort, ind] = sort(b);
segpoint = find(diff(bsort)>= delta);
if (isempty(segpoint))
    tempseg = ones(p,1);
else
    L = length(segpoint);
    tempseg = zeros(p,1);
    tempseg(1:segpoint(1)) = 1;
    for s = 2:L
        tempseg((segpoint(s-1)+1):segpoint(s))=s;
    end
    tempseg((segpoint(L)+1):p) = L+1;
end
    
% changing back the labeling
segment(ind) = tempseg;
    
% decide the penalties
temp = repmat(segment, 1, p);
temp = abs(temp - temp');
withinG = (temp==0);
neighborG = (temp==1);

end