

function srd=scadrightderv(coef, a, lam)

% this function evaluates the right hand derivative of the scad derivatives
% on [0, \infty)

%  coef:    column vector coefficients or their absolute values
%  a:       parameter in scad
%  lam:     parameter in scad

%  srd: the right hand side derivative of scad


srd = lam*((abs(coef)<=lam)+ max(a*lam-abs(coef), 0).*(abs(coef)>lam)/((a-1)*lam));
srd(isnan(srd))=0;

end

