function [b_oracle, K] = oracle_panel(y, x, group_true, T)

[n, p] = size(x);
N = n/T;
group_true_exact = kron(group_true, ones(T,1));
K = max(group_true);

b_oracle = zeros(p, N);
for ii = 1:K
	y_temp = y(group_true_exact==ii);
	x_temp = x(group_true_exact==ii, :);
	b_temp = panel_fe(y_temp, x_temp, T); 
    b_oracle(:,group_true==ii) = repmat(b_temp, 1, sum(group_true==ii));
end

end


