function [trivial_group_indicator, trivial_group_index] = find_trivial_groups(b, eta)
%FIND_TRIVIAL_GROUP find the trivial groups with group member less than
%eta*100 percent.

% b: p * N
% eta: 0 <= eta < 1/2

b = round(b*1e4) / 1e4;
[p, N] = size(b);
if (p < N)
    b = b';
else
    N = p;
end
[~, ~, full_index] = unique(b, 'rows');
K = max(full_index);

trivial_group_indicator = zeros(N, 1);
for ii = 1:K
    if (sum(full_index==ii)/N <= eta)
        trivial_group_indicator(full_index == ii) = true;
    end
end
trivial_group_index = find(trivial_group_indicator);
end

