function [b, K, obj, iternum, t] = cardsest_panel(x, y, T, b_prelim, b_init, delta, eta, lam_within, lam_neighbor, eps0, maxnum, penfunc, solver)
%CARDSEST_PANEL estimate parameters in panel data using CARDS method

[nn, p] = size(x);
N = nn/T; % the number of units

if (size(y,1)~=nn || size(y,2)~=1 || size(b_init,1)~=p || size(b_init, 2)~=N)
    error('Dimensions of inputs do not match!');
end

% construct the hybrid penalty
withinG = zeros(N, N, 2);
neighborG = zeros(N, N, 2);
for ii = (p-1):p
    b_criteria = b_prelim(ii,:)';
    [~, withinG(:,:,ii), neighborG(:,:,ii)] = segments_panel(b_criteria, delta);
end
% 
withinG = sum(withinG, 3);
neighborG = sum(neighborG, 3);
% b_criteria = criteria_para(b_prelim);
%b_criteria = b_prelim(1,:)'-b_prelim(2,:)'; % new criteria
% [~, withinG, neighborG] = segments_panel(b_criteria, delta);

if (strcmp(solver, 'ampl')) 
    % initialize
    ampl_write_param_panel('parameters.dat', N, T, p, x, y);
    b_old = b_init;
    test = 1;
    iternum = 0;    
    % iteration
    tic
    while(test)
        % get the weight matrix in LLA
        btemp = b_old;
        srd_within = zeros(N, N);
        srd_neighbor = zeros(N, N);
                
        if (strcmp(penfunc, 'scad')) 
            for ii = 1:N
                for jj = 1:N
                    dist = norm(btemp(:,ii) - btemp(:,jj), 1);
                    srd_within(ii, jj) = scadrightderv(dist, 3.7, lam_within) * withinG(ii, jj);
                    srd_neighbor(ii, jj) = scadrightderv(dist, 3.7, lam_neighbor) * neighborG(ii, jj);
                end
            end
        elseif (strcmp(penfunc, 'l1'))
            srd_within = lam_within * withinG;
            srd_neighbor = lam_neighbor * neighborG;
        end
        bweights = srd_within + srd_neighbor;
        
        % solve the convex problem
        ampl_write_weights_panel('weights.dat', N, bweights);
        system('ampl cardsest_panel.run >  cards_panel.out');
        [obj, b_new] = ampl_read_sol_panel('cards_panel.out', p, N);
        
        % check the convergence criteria
        if(max(max(abs(b_new - b_old)))<eps0)
            test = 0;
        end
        iternum = iternum +1;
        if(iternum > maxnum)
            test = 0;
        end
        if (strcmp(penfunc, 'l1'))
            test = 0;
        end
        
        % update
        b_old = b_new;
    end
    
    % the idea is this. First we use eta to get the number of observations
    % under which we should eliminate it/them as a group. Denoted it as
    % 'min_group_num'. Next we use the information get from unique (of
    % course with all the output information rather than 'model') to
    % construct the number of elements in each group. 
    % 2. We start from the groups with the least number of obesrvations and
    % less than 'min_group_num', and change the group identification to
    % these with group member greater than 'min_group_num'. Use for the
    % repeat the process, then we set the new group identifiation as the
    % one which makes the objective function minimized.
    % 3. loop through all the chosen elements and help them to find the new
    % group identification. 
    %
    % MAKE SURE TO WRITE OUT THE CODE BEFORE THURSDAY.
    %
        
    [b, K] = eliminate_trivial_group(x, y, T, b_new, eta);

%     [~, ~, model] = unique(b','rows');
%     K = max(model);
%     group_member_num = zeros(K, 1);
%     for ii = 1:K
%         group_member_num(ii) = sum(model==ii);
%     end
%     
%     min_group_num = N * eta;
%     large_ind = find(group_member_num > min_group_num);
%     
%     for ii = 1:K
%         for jj = 1:min_group_num
%             ind = find(group_member_num == jj)
%         end
%     end
    
    
    
    t = toc;
end

end

