# This script generates estimates and saves the results under 
# the assumption of trivariate normality of budget share residuals.
# These results are used as starting points in the estimation of all
# other specifications.

# Setup ----
library(tictoc)
library(data.table)
library(copula)
library(wrapr)
library(nloptr)
library(sn)
library(Matrix)
library(numDeriv)
library(matrixcalc)
library(bbmle)

# Load user-written functions for the models' implementation
source("functions.R")

# Generation of model - data combinations ----

# Databases
dbs <- c("single", "married", "child")
# Models
models <- c("aids","aids_r","quaids","quaids_r","ml","ml_r")

# Generate all combinations
combs <- expand.grid(dbs,models,stringsAsFactors = F)

# Estimations ----

for (i in 1:nrow(combs)){
  
  db <- combs[i,1]
  model <- combs[i,2]
  
  # Call the wrapper function for estimation 
  est0 <- wraper_est(db = db, model = model,
                     m1 = "n", m2 = "n",
                     cop_fam = "normal",
                     sel1 = 1, sel2 = 2,
                     transform = "no",
                     quiet = F, Num = F)

  # Save results
  name <- paste("cs",db,model, sep = "_")
  save(est0,
       file = paste("start_points/",name,".RData",sep =""))
  
}