% clear;

%%%%%%%%%  Get Data %%%%%%%%%%%%%%%
% fullretdata = csvread('DJIA_ret.csv')*100;  
% fullretdata = csvread('SANDP_ret.csv')*100;
% fullretdata = csvread('NASDAQ_ret.csv')*100;
fullretdata = csvread('FTSE_ret.csv')*100;
% fullretdata = csvread('Kospi_ret.csv')*100;
% fullretdata = csvread('Bovespa_ret.csv')*100;
[T,N] = size(fullretdata);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

retdat = fullretdata;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Estimate DCS models without leverage (Not in the paper).  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[sigmas1,nlnL1,scores1,resfull1,covarmat1,ef1] = DCS_T_vol_model([-1.5 .9 .05 6 1],retdat,1);
[sigmas2,nlnL2,scores2,resfull2,covarmat2,ef2] = DCS_AT_vol_model([-1.5 .95 .05 6 10 1],retdat,0);
[sigmas3,nlnL3,scores3,resfull3,covarmat3,ef3] = DCS_ST_vol_model([-1.5 .95 .05 .6 7 1],retdat,0);
[sigmas4,nlnL4,scores4,resfull4,covarmat4,ef4] = DCS_AST_vol_model([-1.5 .95 .05 .6 7 35 1],retdat,0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Estimate  DCS models with leverage   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%  Estimate the ST DCS Model with leverage  %%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Note: The function has inbuilt alternative starting values % %%%%

[sigmas5,nlnL5,scores5,resfull5,covarmat5,ef5] = DCS_ST_vol_wlev_model([-.1 .95 .05 .52 .04 7 .1],retdat,0);

%%%%  Diagnostics
[a51,a52,a53] = st_dcs_diagnostics(resfull5,retdat)
% [ks5,pval5,bootdist5]=dcs_st_ks_bootstrap(resfull5,retdat,sigmas5,300,499);

%%%%  Estimation with random stating values over a grid %%%%

lengthk = 7;
iter = 50;
drs = rand(iter,lengthk);
drs = drs.*repmat([-1 .15 .15 .2 .15 30 .2],iter,1);
drs = drs + repmat([-1 .84 0 .4 0 2 -.1],iter,1);
vecpar5 = zeros(iter,lengthk);
vecnl5 = zeros(iter,1)+1000000;
matsig = zeros(T,iter);
parfor i=1:iter
    i
[sigmas5,nlnL5,scores5,resfull5,covarmat5,ef5] = DCS_ST_vol_wlev_model(drs(i,:),retdat,0);
if isreal(nlnL5)==1
vecpar5(i,:) = resfull5;
vecnl5(i,1) = nlnL5;
matsig(:,i) = sigmas5;
end
end
[Vaa,Iaa] = sort(vecnl5);
resfull5 = vecpar5(Iaa(1),:)
sigmas5 = matsig(:,Iaa(1));
nlnL5 = vecnl5(Iaa(1),1)
bic5 = 2*nlnL5+7*log(T)

%%%%  Diagnostics
[a51,a52,a53] = st_dcs_diagnostics(resfull5,retdat)
% [ks5,pval5,bootdist5]=dcs_st_ks_bootstrap(resfull5,retdat,sigmas5,300,499);


%%%%  Estimate the T DCS Model with leverage  %%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Note: The function has inbuilt alternative starting values % %%%%

[sigmas6,nlnL6,scores6,resfull6,covarmat6,ef6] = DCS_T_vol_wlev_model([-.01 .95 .05 .1 7 0],retdat,1);

%%%%  Diagnostics
[a61,a62,a63] = t_dcs_diagnostics(resfull6,retdat)
% [ks6,pval6,bootdist6]=dcs_t_ks_bootstrap(resfull6,retdat,sigmas6,300,499);

%%%%  Estimate the AST DCS Model with leverage  %%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Note: The function has inbuilt alternative starting values % %%%%

[sigmas7,nlnL7,scores7,resfull7,covarmat7,ef7] = DCS_AST_vol_wlev_model([0.01 .95 .05 .5 .04 7 30 -.1],retdat,0);

%%%%  Estimation with random stating values over a grid %%%%

lengthk = 8;
iter = 50;
drs = rand(iter,lengthk);
drs = drs.*repmat([-1 .15 .15 .2 .15 15 35 .2],iter,1);
drs = drs + repmat([2 .84 0 .4 0 2 2 -.1],iter,1);
vecpar7 = zeros(iter,lengthk);
vecnl7 = zeros(iter,1)+1000000;
matsig = zeros(T,iter);
parfor i=1:iter
    i
[sigmas7,nlnL7,scores7,resfull7,covarmat7,ef7] = DCS_AST_vol_wlev_model(drs(i,:),retdat,0);
if isreal(nlnL7)==1
vecpar7(i,:) = resfull7;
matsig(:,i) = sigmas7;
vecnl7(i,1) = nlnL7;
end
end
[Vaa,Iaa] = sort(vecnl7);
resfull7 = vecpar7(Iaa(1),:)
sigmas7 = matsig(:,Iaa(1));
nlnL7 = vecnl7(Iaa(1),1)
bic7 = 2*nlnL7+8*log(T)

%%%%  Diagnostics
[a71,a72,a73] = ast_dcs_diagnostics(resfull7,retdat)
% [ks7,pval7,bootdist7]=dcs_ast_ks_bootstrap(resfull7,retdat,sigmas7,300,499);

%%%%  Estimate the AT DCS Model with leverage  %%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Note: The function has inbuilt alternative starting values % %%%%

[sigmas8,nlnL8,scores8,resfull8,covarmat8,ef8] = DCS_AT_vol_wlev_model([-.01 .95 .05 .04 7 30 -.1],retdat,0);

%%%%  Diagnostics
[a81,a82,a83] = at_dcs_diagnostics(resfull8,retdat)
% [ks8,pval8,bootdist8]=dcs_at_ks_bootstrap(resfull8,retdat,sigmas8,300,499);

%%%%  Estimation with random stating values over a grid %%%%

lengthk = 7;
iter = 50;
drs = rand(iter,lengthk);
drs = drs.*repmat([-1 .3 .15 .15 10 10 .2],iter,1);
drs = drs + repmat([2 .7 0 0 2 2 -.1],iter,1);
vecpar8 = zeros(iter,lengthk);
vecnl8 = zeros(iter,1)+10000000;
matsig = zeros(T,iter);
parfor i=1:iter
    i
[sigmas8,nlnL8,scores8,resfull8,covarmat8,ef8] = DCS_AT_vol_wlev_model(drs(i,:),retdat,0);
if isreal(nlnL8)==1
vecpar8(i,:) = resfull8;
vecnl8(i,1) = nlnL8;
matsig(:,i) = sigmas8;
end
end
[Vaa,Iaa] = sort(vecnl8);
resfull8 = vecpar8(Iaa(1),:);
sigmas8 = matsig(:,Iaa(1));
nlnL8 = vecnl8(Iaa(1),1);
bic8 = 2*nlnL8+7*log(T);

%%%%  Diagnostics
[a81,a82,a83] = at_dcs_diagnostics(resfull8,retdat)
% [ks8,pval8,bootdist8]=dcs_at_ks_bootstrap(resfull8,retdat,sigmas8,300,499);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Construct inputs for QQ plots of diestibutional fit  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%  QQ for model 7 - DCS AST with leverage
a=retdat;
standres = (a-resfull7(8))./(sigmas7);
nul = resfull7(6);
nur = resfull7(7);
alpha = resfull7(4);
Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);

for t=1:length(a)
    if a(t,1)<=resfull7(8)
        standres(t,1) = standres(t,1)/(2*astar);
    else
        standres(t,1) = standres(t,1)/(2*(1-astar));
    end
end


%%%%%

sortstandres = sort(standres);
ind1 = sum(sign(sortstandres));
ind = .5*(length(a)-abs(ind1))-ind1;

asymt = zeros(length(a),1);
for t=1:length(a)
    if t<=ind
        asymt(t,1) = tinv(t/length(a),resfull7(6));
    else
        asymt(t,1) = tinv(t/length(a),resfull7(7));
    end
end
standres7 = standres;
asymt7=asymt;
h = qqplot(standres7,asymt7)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  QQ for model 8 - DCS AT with leverage
a=retdat;
standres = (a-resfull8(7))./(sigmas8);

nul = resfull8(5);
nur = resfull8(6);
alpha = .5;
Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);

for t=1:length(a)
    if a(t,1)<=resfull8(7)
        standres(t,1) = standres(t,1)/(2*astar);
    else
        standres(t,1) = standres(t,1)/(2*(1-astar));
    end
end
sortstandres = sort(standres);
ind1 = sum(sign(sortstandres));
ind = .5*(length(a)-abs(ind1))-ind1;

asymt = zeros(length(a),1);
for t=1:length(a)
    if t<=ind
        asymt(t,1) = tinv(t/(length(a)+1),resfull8(5));
    else
        asymt(t,1) = tinv(t/(length(a)+1),resfull8(6));
    end
end
asymt8=asymt;
standres8 = standres;
h = qqplot(standres8,asymt8)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  QQ for model 5 - DCS ST with leverage
a=retdat;
standres = (a-resfull5(7))./(sigmas5);

nul = resfull5(6);
nur = resfull5(6);
alpha = resfull5(4); 
Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);

for t=1:length(a)
    if a(t,1)<=resfull5(7)
        standres(t,1) = standres(t,1)/(2*astar);
    else
        standres(t,1) = standres(t,1)/(2*(1-astar));
    end
end
sortstandres = sort(standres);
ind1 = sum(sign(sortstandres));
ind = .5*(length(a)-abs(ind1))-ind1;

asymt = zeros(length(a),1);
for t=1:length(a)
    if t<=ind
        asymt(t,1) = tinv(t/length(a),resfull5(6));
    else
        asymt(t,1) = tinv(t/length(a),resfull5(6));
    end
end
standres5 = standres;
asymt5=asymt;
h = qqplot(standres5,asymt5)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  QQ for model 6 - DCS T with leverage
a=retdat;
tstandres = (a)./(sigmas6);
asymt6 = zeros(length(a),1);
for t=1:length(a)
        asymt6(t,1) = tinv(t/(length(a)+1),resfull6(5));
end
h = qqplot(tstandres,asymt6)

[sort(tstandres) asymt6]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Make joint QQ plots


subplot(2,2,1)
qqplot(tstandres,asymt6)
title('QQ plot for t-dist vs data')
ylabel('T-dist')
xlabel('Sample Quantile')
subplot(2,2,2)
qqplot(standres5,asymt5)
title('QQ plot for S.T - dist vs data')
ylabel('ST-dist')
xlabel('Sample Quantile')
subplot(2,2,3)
qqplot(standres8,asymt8)
title('QQ plot for A.T - dist vs data')
ylabel('AT-dist')
xlabel('Sample Quantile')
subplot(2,2,4)
qqplot(standres7,asymt7)
title('QQ plot for A.S.T - dist vs data')
ylabel('AST-dist')
xlabel('Sample Quantile')

set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperSize', [8.25 4.5]);
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperPosition', [0 0 8.25 4.25]);



subplot(2,2,1)
qqplot(standres5,asymt5)
title('ST Distribution - Left Tail')
ylabel('Fitted Quantile')
xlabel('Sample Quantile')
subplot(2,2,2)
qqplot(standres5,asymt5)
title('ST Distribution - Right Tail')
ylabel('Fitted Quantile')
xlabel('Sample Quantile')
subplot(2,2,3)
qqplot(standres7,asymt7)
title('AST Distribution - Left Tail')
ylabel('Fitted Quantile')
xlabel('Sample Quantile')
subplot(2,2,4)
qqplot(standres7,asymt7)
title('AST Distribution - Right Tail')
ylabel('Fitted Quantile')
xlabel('Sample Quantile')

set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperSize', [8.25 4.5]);
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperPosition', [0 0 8.25 4.25]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Estimate Standard Errors for DCS models with leverage   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%  DCS AST model
vParms = resfull7;
vParms(2) = log(vParms(2)/(.999-vParms(2)));
vParms(3) = log(vParms(3));
vParms(4) = log(vParms(4)/(.999-vParms(4)));
vParms(6) = log(vParms(6)/(330-vParms(6)));
vParms(7) = log(vParms(7)/(330-vParms(7)));

mHess = fdhess('DCS_AST_vol_wlev_nll',vParms',retdat,0);

if isreal(sum(sqrt(diag(inv(mHess))))) ~=1
vGradientfull = gradnt('DCS_AST_vol_wlev_nll', vParms, eps.^(1/2),retdat,1);
mHess = vGradientfull'*vGradientfull;
end
vGradient = gradnt('DCS_AST_vol_wlev_restrictions', vParms, 0.001);
mCovMat = vGradient/mHess;
mCovMat = mCovMat*vGradient';
vStdErrors7 = sqrt(diag(mCovMat));

[resfull7 ; vStdErrors7']

%%%%%  DCS AT model
vParms = resfull8;
vParms(2) = log(vParms(2)/(.999-vParms(2)));
vParms(5) = log(vParms(5)/(330-vParms(5)));
vParms(6) = log(vParms(6)/(330-vParms(6)));

mHess = fdhess('DCS_AT_vol_wlev_nll',vParms',retdat,0);
if isreal(sum(sqrt(diag(inv(mHess))))) ~=1
vGradientfull = gradnt('DCS_AT_vol_wlev_nll', vParms, eps.^(1/2),retdat,1);
mHess = vGradientfull'*vGradientfull;
end
vGradient = gradnt('DCS_AT_vol_wlev_restrictions', vParms, 0.001);
mCovMat = vGradient/mHess;
mCovMat = mCovMat*vGradient';
vStdErrors8 = sqrt(diag(mCovMat));

[resfull8 ; vStdErrors8']

%%%%%  DCS ST model

vParms = resfull5;
vParms(2) = log(vParms(2)/(.999-vParms(2)));
vParms(3) = log(vParms(3));
vParms(4) = log(vParms(4)/(.999-vParms(4)));
vParms(6) = log(vParms(6)/(330-vParms(6)));

mHess = fdhess('DCS_ST_vol_wlev_nll',vParms',retdat);
vGradient = gradnt('DCS_ST_vol_wlev_restrictions', vParms, 0.001);
mCovMat = vGradient/mHess;
mCovMat = mCovMat*vGradient';
vStdErrors5 = sqrt(diag(mCovMat));

[resfull5 ; vStdErrors5']

%%%%%  DCS T model

vParms = resfull6;
vParms(2) = log(vParms(2)/(.999-vParms(2)));
vParms(5) = log(vParms(5));

mHess = fdhess('DCS_T_vol_wlev_nll',vParms',retdat);
vGradient = gradnt('DCS_T_vol_wlev_restrictions', vParms, 0.001);
mCovMat = vGradient/mHess;
mCovMat = mCovMat*vGradient';
vStdErrors6 = sqrt(diag(mCovMat));

[resfull6 ; vStdErrors6']

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


