function [bic,lb,ks,f,fat] = at_dcs_diagnostics(thetahat,y)

T = length(y);

%%%%%%  get scales and likelihood
transtheta = thetahat;
transtheta(2) = log(transtheta(2)/(.999-transtheta(2)));
transtheta(5) = log(transtheta(5)/(330-transtheta(5)));
transtheta(6) = log(transtheta(6)/(330-transtheta(6)));
[nlnL,sigmas,scores] = DCS_AT_vol_wlev_nll(transtheta,y,0); 

%%%%%%  Calc BIC
bic = 2*nlnL+length(thetahat)*log(T);

%%%%%  Test for autocorrealtion in the squared standardized resids
mu = thetahat(7);
standres = (y-mu)./sigmas;
[lbh,lbpValue,lbstat,lbcValue] = lbqtest(standres.^2,20,0.05);
lb = [lbpValue ; lbstat];

%%%%  Kolmogorov Smirnov test (just stat - no crit values)
Ord = sort(standres);
f = [0 1:(T-1)]'/(T);
nul  = thetahat(5);
nur  = thetahat(6);
alpha=.5;
Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
fat = 2*alpha*tcdf(min(Ord/(2*astar),0), nul) + 2*(1-alpha)*(tcdf(max(Ord/(2*(1-astar)),0), nur) - .5);
ks = max(abs(f-fat));
end