function [nlnL,sigmas,scores] = DCS_T_vol_wlev_nll(param,y)
%% Function for the negative loglikelihood of the DCS_T egarch score driven volatility model with leverage .
%% If an initial parameter is provided for the mode (at the end of the parameter vector), the 
%% mode will be estimated by ML.  Otherwise it is set equal to zero.
%% The time varying scale is constrained using an exponential link function.
%% The score is scaled by the inverse of the information quantity in the dynamic equation for the scale.

omega = param(1);                    %%  parametised in terms of the unconditional level of lambda.
phi = .999/(1+exp(-param(2)));
kappa = param(3);
psi = param(4);
nu = exp(param(5));
mu = 0;
if length(param) == 6
        mu = param(6);
end
    
T = length(y);

lambda = [omega/(1-phi) ; zeros(T,1)];      %% scale is initialised at the unconditional expectation.
sscore = zeros(T+1,1);                          %% scaled score is initialised at 0.
levterm = 0;

ymm2 = (y-mu).^2;
smy = sign(-y);

for t=1:T
    
    lambdat = omega + phi*lambda(t) + kappa*sscore(t) + psi*levterm;

    sigmat = exp(lambdat);
    F = 1/nu*ymm2(t)/(sigmat)^2;     %%  Determination of beta variable
    scoret = (nu+1)*F/(1+F) - 1;
    scalet = (nu+3)/(2*nu);
    sscoret = scalet*scoret;
    levterm = smy(t)*(sscoret+1);
    
    lambda(t+1,1) = lambdat;
    sscore(t+1,1) = sscoret;
    
end

lambdas = lambda(2:(T+1),1); 
sigmas = exp(lambdas);               %%  (T*1) vector of tv scales for skew-t dist
scores = sscore(2:(T+1),1);                    %%  (T*1) vector of scaled scores

    llf1 = log(gamma(nu/2+.5)/(gamma(nu/2)*sqrt(pi*nu)));
    llf2 = -lambdas;
    llf3 = -(nu/2+.5)*log(1 + 1/nu*ymm2./(sigmas.^2));

    llf = sum(llf1 + llf2 + llf3);


nlnL = -1*llf;


end