function [storesigmas,storenlnL,storescores,storeresfull,covarmat,storeef] = DCS_T_vol_wlev_model(startparam,y,extras)

%% Function to estiamte a DCS_T egarch volatility model with leverage.
%% input : param is the vector of initial values for the optimiser (note order)
%%         y is a univariate time series
%%         extras is a binary indicator (1 = yes) for whether additonal output should be calculated.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%settings and for the optimisation problem
    opt = optimset('TolX', 0.0001, 'Display', 'off', 'MaxIter', 5000, 'MaxFunEvals', 5000, 'HessUpdate', 'bfgs') ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

startvals = startparam;
startvals = [startvals ;  .01 .98 .05 .03 10 0];
startvals = [startvals ;  .01 .98 .1 .03 10 0];
startvals = [startvals ;  .02 .93 .1 .03 4 0];


storenlnL = 100000000;
storesigmas = [];
storeresfull = [];
storeef = [];
storescores = [];

for i=1:length(startvals(:,1))
    
param = startvals(i,:);

param(2) = log(param(2)/(.999-param(2)));
param(5) = log(param(5));

fst = @(p)DCS_T_vol_wlev_nll(p,y);
[resfull,val,ef] = fminsearch(fst,param,opt);                 %% conduct optimisation
% [resfull,val,ef] = fminunc(fst,param,opt); 
[nlnL,sigmas,scores] = DCS_T_vol_wlev_nll(resfull,y);        %% Evaluate model at MLEs to get fitted states, scores and llf

resfull(2) = .999/(1+exp(-resfull(2)));
resfull(5) = exp(resfull(5));

if (nlnL < storenlnL)
    storenlnL = nlnL;
    storesigmas = sigmas;
    storeresfull = resfull;
    storeef = ef;
    storescores = scores;
end


end

covarmat = eye(length(param));

if (extras == 1)
   covarmat = eye(length(param));                            %% To be updated with analytical matrix at a later date 
end
end