function [nlnL,sigmas,scores,step1] = DCS_T_vol_nll(param,y)
%% Likelihood for the DCS T egarch volatility model.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

omega = param(1);                   
phi = .999/(1+exp(-param(2)));
kappa = param(3);
nu = param(4);
mu = 0;
if length(param) == 5
        mu = param(5);
end
    
T = length(y);

lambda = [omega/(1-phi) ; zeros(T,1)];      %% scale is initialised at the unconditional expectation.
sscore = zeros(T+1,1);                          %% scaled score is initialised at 0.

ymm2 = (y-mu).^2;


for t=1:T
    
    lambdat = omega + phi*lambda(t) + kappa*sscore(t);

    sigmat = exp(lambdat);
    F = 1/nu*((y(t)-mu)/(sigmat))^2;     %%  Determination of beta variable
    scoret = (nu+1)*F/(1+F) - 1;
    scalet = (nu+3)/(2*nu);
    sscoret = scalet*scoret;
    
    lambda(t+1,1) = lambdat;
    sscore(t+1,1) = sscoret;
    
end
lambdas = lambda(2:(T+1),1); 
sigmas = exp(lambdas);               %%  (T*1) vector of tv scales for skew-t dist
scores = sscore(2:(T+1),1);                    %%  (T*1) vector of scaled scores

    llf1 = log(gamma(nu/2+.5)/(gamma(nu/2)*sqrt(pi*nu)));
    llf2 = -lambdas;
    llf3 = -(nu/2+.5)*log(1 + 1/nu*ymm2./(sigmas.^2));

    llf = sum(llf1 + llf2 + llf3);


nlnL = -1*llf;

    lambdatp1 = omega + phi*lambdat + kappa*sscoret;
    step1 = exp(lambdatp1);

end