
tic

%%%%%%%%%  Get Data %%%%%%%%%%%%%%%
fullretdata1 = xlsread('FTSE_ret');
fullretdata2 = xlsread('SANDP_ret');
[T,N] = size(fullretdata);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

gam = 5;

dat1 = fullretdata1(1:end,1)*100;
dat2 = fullretdata2(1:end,1)*100;

T = length(dat1); 

W = 1000; 
H = 1;
RE = 22;
iter = floor((T-W)/H);

storew = zeros(iter,4);

storepret_ast = zeros(H,iter);
storepret_at = zeros(H,iter);
storepret_st = zeros(H,iter);
storepret_t = zeros(H,iter);

counter = 0;

for j=1:iter

        counter = counter + 1;
    [j iter]
    
    li = 1 + (j-1)*H;
    ui = li + W-1;
    fi = ui + H;

sdat1 = dat1(li:ui,1);
sdat2 = dat2(li:ui,1);

fdat1 = dat1(ui+1:fi,1);
fdat2 = dat2(ui+1:fi,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Estimate Models  %%%%%%
if counter == 1
    
    
    parfor i = 1:4
    
        if i==1
        %%%%%%%%%%%%%%%%  AST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
        [ast_dcs_wlev_h1,nlnL11,scores11,ast_dcs_wlev_pars1,covarmat11,ef11,ast_dcs_wlev_step11,llf11] = beta_asym_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 7 10 .05],sdat1,0);
        [ast_dcs_wlev_h2,nlnL21,scores21,ast_dcs_wlev_pars2,covarmat21,ef21,ast_dcs_wlev_step12,llf21] = beta_asym_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 7 10 .05],sdat2,0);

        ast_u1 =  ast_cdf(sdat1,[ast_dcs_wlev_pars1(4) ast_dcs_wlev_pars1(6:8)],ast_dcs_wlev_h1);
        ast_u2 =  ast_cdf(sdat2,[ast_dcs_wlev_pars2(4) ast_dcs_wlev_pars2(6:8)],ast_dcs_wlev_h2);

        % est copulas
        options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
        lower = 0.0001;
        theta0 = 1.2;
        [ kappa_ast LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);
    
    
        elseif i==2    
            %%%%%%%%%%%%%%%%  AT DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
            [at_dcs_wlev_h1,nlnL12,scores12,at_dcs_wlev_pars1,covarmat12,ef12,at_dcs_wlev_step1f1] = beta_asym_t_vol_wlev_model_res([.01 .98 .05 .02 7 10 .05],sdat1,0);
            [at_dcs_wlev_h2,nlnL22,scores22,at_dcs_wlev_pars2,covarmat22,ef22,at_dcs_wlev_step1f2] = beta_asym_t_vol_wlev_model_res([.01 .98 .05 .02 7 10 .05],sdat2,0);

        at_u1 =  ast_cdf(sdat1,[0.5 at_dcs_wlev_pars1(5:7)],at_dcs_wlev_h1);
        at_u2 =  ast_cdf(sdat2,[0.5 at_dcs_wlev_pars2(5:7)],at_dcs_wlev_h2);


        % est copulas
        options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
        lower = 0.0001;
        theta0 = 1.2;
        [ kappa_at LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[at_u1,at_u2]);
            
        elseif i==3            
            %%%%%%%%%%%%%%%%  ST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
            
            [st_dcs_wlev_h1,nlnL13,scores13,st_dcs_wlev_pars1,covarmat13,ef13,st_dcs_wlev_step1f1] = beta_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 10 .05],sdat1,0);
            [st_dcs_wlev_h2,nlnL23,scores23,st_dcs_wlev_pars2,covarmat23,ef23,st_dcs_wlev_step1f2] = beta_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 10 .05],sdat2,0);

        st_u1 =  ast_cdf(sdat1,[st_dcs_wlev_pars1(4) st_dcs_wlev_pars1(6) st_dcs_wlev_pars1(6:7)],st_dcs_wlev_h1);
        st_u2 =  ast_cdf(sdat2,[st_dcs_wlev_pars2(4) st_dcs_wlev_pars2(6) st_dcs_wlev_pars2(6:7)],st_dcs_wlev_h2);


        % est copulas
        options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
        lower = 0.0001;
        theta0 = 1.2;
        [ kappa_st LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[st_u1,st_u2]);
            
        else
            %%%%%%%%%%%%%%%%  T DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
            
            [beta_t_egarch_wlev_h1,nlnL14,scores14,beta_t_egarch_wlev_pars1,covarmat14,ef14,beta_t_egarch_wlev_step1f1] = beta_t_vol_wlev_model([.01 .98 .05 .03 10 0],sdat1,0);
            [beta_t_egarch_wlev_h2,nlnL24,scores24,beta_t_egarch_wlev_pars2,covarmat24,ef24,beta_t_egarch_wlev_step1f12] = beta_t_vol_wlev_model([.01 .98 .05 .03 10 0],sdat2,0);

        t_u1 =  ast_cdf(sdat1,[0.5 beta_t_egarch_wlev_pars1(5) beta_t_egarch_wlev_pars1(5:6)],beta_t_egarch_wlev_h1);
        t_u2 =  ast_cdf(sdat2,[0.5 beta_t_egarch_wlev_pars2(5) beta_t_egarch_wlev_pars2(5:6)],beta_t_egarch_wlev_h2);


        % est copulas
        options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
        lower = 0.0001;
        theta0 = 1.2;
        [ kappa_t LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[t_u1,t_u2]);
            
        end
    end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%  estimate marginals  %%%%%%
    parfor i = 1:4
    
        if i==1
%%%%%%%%%%%%%%%%  AST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[sigmas,ast_dcs_wlev_step11] = beta_asym_skew_t_vol_wlev_eval(ast_dcs_wlev_pars1,sdat1);
[sigmas,ast_dcs_wlev_step12] = beta_asym_skew_t_vol_wlev_eval(ast_dcs_wlev_pars2,sdat2);
optweight_ast = ast_optw(gam,kappa_ast, [ast_dcs_wlev_pars1(4) ast_dcs_wlev_pars1(6:8) ast_dcs_wlev_step11], [ast_dcs_wlev_pars2(4) ast_dcs_wlev_pars2(6:8) ast_dcs_wlev_step12]);

elseif i==2 
%%%%%%%%%%%%%%%%  AT DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[sigmas,at_dcs_wlev_step1f1] = beta_asym_t_vol_wlev_eval(at_dcs_wlev_pars1,sdat1);
[sigmas,at_dcs_wlev_step1f2] = beta_asym_t_vol_wlev_eval(at_dcs_wlev_pars2,sdat2);
optweight_at = ast_optw(gam,kappa_at, [0.5 at_dcs_wlev_pars1(5:7) at_dcs_wlev_step1f1], [0.5 at_dcs_wlev_pars2(5:7) at_dcs_wlev_step1f2]);

elseif i==3 
%%%%%%%%%%%%%%%%  ST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[sigmas,st_dcs_wlev_step1f1] = beta_skew_t_vol_wlev_eval(st_dcs_wlev_pars1,sdat1);
[sigmas,st_dcs_wlev_step1f2] = beta_skew_t_vol_wlev_eval(st_dcs_wlev_pars2,sdat2);
optweight_st = ast_optw(gam,kappa_st, [st_dcs_wlev_pars1(4) st_dcs_wlev_pars1(6) st_dcs_wlev_pars1(6:7) st_dcs_wlev_step1f1], [st_dcs_wlev_pars2(4) st_dcs_wlev_pars2(6) st_dcs_wlev_pars2(6:7) st_dcs_wlev_step1f2]);

        else
%%%%%%%%%%%%%%%%  T DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[sigmas,beta_t_egarch_wlev_step1f1] = beta_t_vol_wlev_eval(beta_t_egarch_wlev_pars1,sdat1);
[sigmas,beta_t_egarch_wlev_step1f2] = beta_t_vol_wlev_eval(beta_t_egarch_wlev_pars2,sdat2);
optweight_t = ast_optw(gam,kappa_t, [0.5 beta_t_egarch_wlev_pars1(5) beta_t_egarch_wlev_pars1(5:6) beta_t_egarch_wlev_step1f1], [0.5 beta_t_egarch_wlev_pars2(5) beta_t_egarch_wlev_pars2(5:6) beta_t_egarch_wlev_step1f2]);
        end
    end
%%%%%%%%%%%  Realised returns 

rr_ast = fdat1*optweight_ast + fdat2*(1-optweight_ast);
rr_at = fdat1*optweight_at + fdat2*(1-optweight_at);
rr_st = fdat1*optweight_st + fdat2*(1-optweight_st);
rr_t = fdat1*optweight_t + fdat2*(1-optweight_t);

%%%%%%%%%%%%%  store res

storew(j,:) = [optweight_ast optweight_at optweight_st optweight_t];

storepret_ast(:,j) = rr_ast;
storepret_at(:,j) = rr_at;
storepret_st(:,j) = rr_st;
storepret_t(:,j) = rr_t;

if counter == RE
    counter = 0;
end

% parfor_progress; % Count 
end

% parfor_progress(0); % Clean up

storepret_ast = reshape(storepret_ast,H*iter,1);
storepret_at = reshape(storepret_at,H*iter,1);
storepret_st= reshape(storepret_st,H*iter,1);
storepret_t= reshape(storepret_t,H*iter,1);

pret_all = [storepret_ast storepret_at storepret_st storepret_t];
%%%  Management fees

mean(pret_all)
std(pret_all)
skewness(pret_all)
kurtosis(pret_all)


fun1 = @(f) match_util(f, storepret_st,storepret_ast, gam);    % function of x alone
mf_ast = fzero(fun1,0.0001)*252*100


fun2 = @(f) match_util(f, storepret_st,storepret_at, gam);    % function of x alone
mf_at = fzero(fun2,0.0001)*252*100

fun3 = @(f) match_util(f, storepret_st,storepret_t, gam);    % function of x alone
mf_st = fzero(fun3,0.0001)*252*100


 y = ((1+storepret_st/100).^(1-gam))/(1-gam) - ((1+storepret_at/100).^(1-gam))/(1-gam);
 [beta, R2, R2adj, X2_NW, X2_HH, X2_R, std_NW, std_HH, std_R, t_NW, t_HH, t_R] = olshac(y,ones(length(y),1),1,1);
 

toc



