function res = forecast_ast_dcs(pars,h,x,M,dist,lev)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%   Multistep forecast function for the AST DCS model
%%
%%  INPUTS:  pars = estimated parameters
%%              h = fitted variances
%%              x = in-sample data
%%              M = ou-of-sample window
%%           dist = error distribution (either 'T', 'ST','AT','AST' )
%%            lev = indicator for the presence of a leverage effect (0, for no)
%%
%%  OUTPUT:  fs = M step ahead forecast of the variance
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Note: M = 1 is done directly as the model is observation driven.
%%        M > 1 is done via simulation with 100,000 draws
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = length(x);
y = x(T,1);
s = log(h(T,1));

% if M==1
%     iter = 1;
% else
iter = 500000;
% end

ind1 = round(iter*.01);
ind5 = round(iter*.05);

if lev == 0 
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%  No Leverage  %%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if strcmp('T',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    nu = pars(4);
    mu = pars(5);
   
    tempret = ones(iter,1);
   for i = 1:M
    F = 1/nu*((y-mu)./(exp(s))).^2;     
    scoret = (nu+1)*F./(1+F) - 1;
    scalet = (nu+3)/(2*nu);
    sscoret = scalet*scoret;
       s = delta + kappa*sscoret + phi*s;
       y = trnd(nu,iter,1).*exp(s) + mu;
       tempret = tempret.*(y+1);
   end
   
   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([0.5 nu nu mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
   

   
end  %% close T if

if strcmp('ST',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    alpha = pars(4);
    nu = pars(5);
    mu = pars(6);
    nul = nu;
    nur = nu;
    
    Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
    Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
    astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);
    
        tempret = ones(iter,1);
   for i = 1:M
    pFl = y.^2/(nul*4*astar^2);
    pFr = y.^2/(nur*4*(1-astar)^2);

    if (y <= mu)                                           %%  Determining which side of the density to apply
    F = pFl./(exp(s)).^2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;

    end
       s = delta + kappa*sscoret + phi*s;
       y = generate_ast_rv([alpha nu nu mu],exp(s),iter);
       
       tempret = tempret.*(y+1);
   end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
    
    
    
end  %% close ST if

if strcmp('AT',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    nul = pars(4);
    nur = pars(5);
    mu = pars(6);
    alpha = 0.5;
    
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);

        tempret = ones(iter,1);
    for i = 1:M

pFl = y.^2/nul;
pFr = y.^2/nur;
  
    if (y <= mu)                                           %%  Determining which side of the density to apply

    F = pFl./(exp(s)).^2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;
    
    end
       s = delta + kappa*sscoret + phi*s;
       y = generate_ast_rv([0.5 nul nur mu],exp(s),iter);
       tempret = tempret.*(y+1);
    end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
    
    
end %% close AT if

if strcmp('AST',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    alpha = pars(4);
    nul = pars(5);
    nur = pars(6);
    mu = pars(7);
    
    Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
    Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
    astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
    
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);

        tempret = ones(iter,1);
    for i = 1:M
    pFl = y.^2/(nul*4*astar^2);
    pFr = y.^2/(nur*4*(1-astar)^2);
   
    if (y <= mu)                                           %%  Determining which side of the density to apply

    F = pFl./(exp(s)).^2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;

    end
       s = delta + kappa*sscoret + phi*s;
       y = generate_ast_rv([alpha nul nur mu],exp(s),iter);
       tempret = tempret.*(y+1);
    end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
    
    
end %% close AST if

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%  With Leverage  %%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 if strcmp('T',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    psi = pars(4);
    nu = pars(5);
    mu = pars(6);
        
    tempret = ones(iter,1);
   for i = 1:M
    F = 1/nu*((y-mu)./(exp(s))).^2;     
    scoret = (nu+1)*F./(1+F) - 1;
    scalet = (nu+3)/(2*nu);
    sscoret = scalet*scoret;
       s = delta + kappa*sscoret + phi*s + psi*sign(-y).*(sscoret+1);
       y = trnd(nu,iter,1).*exp(s) + mu;
       tempret = tempret.*(y+1);
   end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([0.5 nu nu mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
   
end  %% close T if

if strcmp('ST',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    alpha = pars(4);
    psi = pars(5);
    nu = pars(6);
    mu = pars(7);
    nul = nu;
    nur = nu;
    
    Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
    Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
    astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);
    
        tempret = ones(iter,1);
   for i = 1:M
    pFl = y.^2/(nul*4*astar^2);
    pFr = y.^2/(nur*4*(1-astar)^2);

    if (y <= mu)                                           %%  Determining which side of the density to apply
    F = pFl./(exp(s))^.2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;

    end
       s = delta + kappa*sscoret + phi*s + psi*sign(-y).*(sscoret+1);
       y = generate_ast_rv([alpha nu nu mu],exp(s),iter);
       tempret = tempret.*(y+1);
   end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
   
end  %% close ST if

if strcmp('AT',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    psi = pars(4);
    nul = pars(5);
    nur = pars(6);
    mu = pars(7);
    alpha = 0.5;
    
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);

        tempret = ones(iter,1);
    for i = 1:M

pFl = y.^2/nul;
pFr = y.^2/nur;
  
    if (y <= mu)                                           %%  Determining which side of the density to apply

    F = pFl./(exp(s)).^2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;
    
    end
       s = delta + kappa*sscoret + phi*s + psi*sign(-y).*(sscoret+1);
       y = generate_ast_rv([alpha nul nur mu],exp(s),iter);
       tempret = tempret.*(y+1);
    end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
   
end %% close AT if

if strcmp('AST',dist) == 1
    
    delta = pars(1);
    phi = pars(2);
    kappa = pars(3);
    alpha = pars(4);
    psi = pars(5);
    nul = pars(6);
    nur = pars(7);
    mu = pars(8);
    
    Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
    Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
    astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
    
    scaletleft = (nul+3)/(2*nul);
    scaletright = (nur+3)/(2*nur);

        tempret = ones(iter,1);
    for i = 1:M
    pFl = y.^2/(nul*4*astar^2);
    pFr = y.^2/(nur*4*(1-astar)^2);
   
    if (y <= mu)                                           %%  Determining which side of the density to apply

    F = pFl./(exp(s)).^2;
    scoret = (nul+1)*F./(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr./(exp(s)).^2;
    scoret = (nur+1)*F./(1+F) - 1;
    sscoret = scaletright*scoret;

    end
       s = delta + kappa*sscoret + phi*s + psi*sign(-y).*(sscoret+1);
       y = generate_ast_rv([alpha nul nur mu],exp(s),iter);
       tempret = tempret.*(y+1);
    end

   sortret = sort(tempret-1);
   
   flv5 = sortret(ind5);
   flv1 = sortret(ind1);
   fle5 = mean(sortret(1:ind5));
   fle1 = mean(sortret(1:ind1));
   
   fuv5 = sortret(iter-ind5);
   fuv1 = sortret(iter-ind1);
   fue5 = mean(sortret((iter-ind5):iter));
   fue1 = mean(sortret((iter-ind1):iter));
   
   fs = mean(exp(s));
   fvar = ast_dcs_variance_calc([alpha nul nur mu],fs);
   
   res = [fvar fs flv5 flv1 fle5 fle1 fuv5 fuv1 fue5 fue1];
   
end %% close AST if

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
end  %% close leverage if 

end